/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.BucketId;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.VisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.VisitorReply;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class VisitorInfoMessage
extends VisitorMessage {
    private Set<BucketId> finishedBuckets = new TreeSet<BucketId>();
    private String errorMessage = "";

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String s) {
        this.errorMessage = s;
    }

    public Set<BucketId> getFinishedBuckets() {
        return this.finishedBuckets;
    }

    public void setFinishedBuckets(Set<BucketId> finishedBuckets) {
        this.finishedBuckets = finishedBuckets;
    }

    @Override
    public DocumentReply createReply() {
        return new VisitorReply(200009);
    }

    public int getType() {
        return 100009;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("VisitorInfoMessage(");
        if (this.finishedBuckets.size() == 0) {
            sb.append("No buckets");
        } else if (this.finishedBuckets.size() == 1) {
            sb.append("Bucket ").append(this.finishedBuckets.iterator().next().toString());
        } else if (this.finishedBuckets.size() < 65536) {
            sb.append(this.finishedBuckets.size()).append(" buckets:");
            Iterator<BucketId> it = this.finishedBuckets.iterator();
            for (int i = 0; it.hasNext() && i < 3; ++i) {
                sb.append(' ').append(it.next().toString());
            }
            if (it.hasNext()) {
                sb.append(" ...");
            }
        } else {
            sb.append("All buckets");
        }
        sb.append(", error message '").append(this.errorMessage).append('\'');
        return sb.append(')').toString();
    }
}

