/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.jrt.slobrok.api.Mirror;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

abstract class LoadBalancer {
    private final Map<String, Integer> cachedIndex = new HashMap<String, Integer>();
    private final List<NodeMetrics> nodeWeights = new ArrayList<NodeMetrics>();
    private final String cluster;

    public LoadBalancer(String cluster) {
        this.cluster = cluster;
    }

    List<NodeMetrics> getNodeWeights() {
        return this.nodeWeights;
    }

    int getIndex(String nodeName) {
        try {
            String s = nodeName.substring(this.cluster.length() + 1);
            s = s.substring(0, s.indexOf("/"));
            s = s.substring(s.lastIndexOf(".") + 1);
            return Integer.parseInt(s);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            String err = "Expected recipient on the form '" + this.cluster + "/x/[y.]number/z', got '" + nodeName + "'.";
            throw new IllegalArgumentException(err, e);
        }
    }

    int getCachedIndex(String nodeName) {
        return this.cachedIndex.computeIfAbsent(nodeName, key -> this.getIndex((String)key));
    }

    protected final synchronized NodeMetrics getNodeMetrics(Mirror.Entry entry) {
        int index = this.getCachedIndex(entry.getName());
        while (this.nodeWeights.size() < index + 1) {
            this.nodeWeights.add(null);
        }
        NodeMetrics nodeMetrics = this.nodeWeights.get(index);
        if (nodeMetrics == null) {
            nodeMetrics = this.createNodeMetrics();
            this.nodeWeights.set(index, nodeMetrics);
        }
        return nodeMetrics;
    }

    protected NodeMetrics createNodeMetrics() {
        return new NodeMetrics();
    }

    abstract Node getRecipient(List<Mirror.Entry> var1);

    abstract void received(Node var1, boolean var2);

    static class Node {
        Mirror.Entry entry;
        NodeMetrics metrics;

        Node(Mirror.Entry e, NodeMetrics m) {
            this.entry = e;
            this.metrics = m;
        }
    }

    static class NodeMetrics {
        private AtomicLong sent = new AtomicLong(0L);
        private AtomicLong received = new AtomicLong(0L);
        private AtomicLong busy = new AtomicLong(0L);

        NodeMetrics() {
        }

        long pending() {
            return this.sent.get() - this.received.get();
        }

        void incSend() {
            this.sent.incrementAndGet();
        }

        void incReceived() {
            this.received.incrementAndGet();
        }

        void incBusy() {
            this.busy.incrementAndGet();
        }

        long sent() {
            return this.sent.get();
        }

        void reset() {
            this.sent.set(0L);
            this.received.set(0L);
            this.busy.set(0L);
        }
    }
}

