/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.document.BucketId;
import com.yahoo.document.BucketIdFactory;
import com.yahoo.documentapi.messagebus.protocol.CreateVisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.ExternalSlobrokPolicy;
import com.yahoo.documentapi.messagebus.protocol.GetBucketListMessage;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveLocationMessage;
import com.yahoo.documentapi.messagebus.protocol.StatBucketMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.WriteDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.WrongDistributionReply;
import com.yahoo.jrt.slobrok.api.IMirror;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.RoutingNodeIterator;
import com.yahoo.messagebus.routing.VerbatimDirective;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StoragePolicy
extends ExternalSlobrokPolicy {
    private static final Logger log = Logger.getLogger(StoragePolicy.class.getName());
    public static final String owningBucketStates = "uim";
    public static final String upStates = "ui";
    private final BucketIdCalculator bucketIdCalculator = new BucketIdCalculator();
    private DistributorSelectionLogic distributorSelectionLogic = null;
    private Parameters parameters;

    public StoragePolicy(String param) {
        this(StoragePolicy.parse(param));
    }

    public StoragePolicy(Map<String, String> params) {
        this(new Parameters(params), params);
    }

    public StoragePolicy(Parameters p, Map<String, String> params) {
        super(params);
        this.parameters = p;
    }

    @Override
    public void init() {
        super.init();
        this.distributorSelectionLogic = new DistributorSelectionLogic(this.parameters, this);
    }

    @Override
    public void doSelect(RoutingContext context) {
        if (context.shouldTrace(1)) {
            context.trace(1, "Selecting route");
        }
        BucketId bucketId = this.bucketIdCalculator.handleBucketIdCalculation(context);
        if (context.hasReply()) {
            return;
        }
        String targetSpec = this.distributorSelectionLogic.getTargetSpec(context, bucketId);
        if (context.hasReply()) {
            return;
        }
        if (targetSpec != null) {
            Route route = new Route(context.getRoute());
            route.setHop(0, new Hop().addDirective((HopDirective)new VerbatimDirective(targetSpec)));
            context.addChild(route);
        } else {
            context.setError(100002, "Could not resolve any distributors to send to in cluster " + this.parameters.clusterName);
        }
    }

    public void merge(RoutingContext context) {
        Reply reply;
        RoutingNodeIterator it = context.getChildIterator();
        Reply reply2 = reply = it.hasReply() ? it.removeReply() : context.getReply();
        if (reply == null) {
            reply = new EmptyReply();
            reply.addError(new Error(100002, "No reply in any children, nor in the routing context: " + context));
        }
        if (reply instanceof WrongDistributionReply) {
            this.distributorSelectionLogic.handleWrongDistribution((WrongDistributionReply)reply, context);
        } else if (reply.hasErrors()) {
            this.distributorSelectionLogic.handleErrorReply(reply, context.getContext());
        } else if (reply instanceof WriteDocumentReply && context.shouldTrace(9)) {
            context.trace(9, "Modification timestamp: " + ((WriteDocumentReply)reply).getHighestModificationTimestamp());
        }
        context.setReply(reply);
    }

    @Override
    public void destroy() {
        this.distributorSelectionLogic.destroy();
    }

    @Override
    public MetricSet getMetrics() {
        return null;
    }

    public static class DistributorSelectionLogic {
        private final HostFetcher hostFetcher;
        private final Distribution distribution;
        private final InstabilityChecker persistentFailureChecker;
        private ClusterState cachedClusterState = null;
        private int oldClusterVersionGottenCount = 0;
        private final int maxOldClusterVersionBeforeSendingRandom;

        public DistributorSelectionLogic(Parameters params, ExternalSlobrokPolicy policy) {
            this.hostFetcher = params.createHostFetcher(policy);
            this.hostFetcher.setRequiredUpPercentageToSendToKnownGoodNodes(params.getRequiredUpPercentageToSendToKnownGoodNodes());
            this.distribution = params.createDistribution(policy);
            this.persistentFailureChecker = new InstabilityChecker(params.getAttemptRandomOnFailuresLimit());
            this.maxOldClusterVersionBeforeSendingRandom = params.maxOldClusterStatesSeenBeforeThrowingCachedState();
        }

        public void destroy() {
            this.hostFetcher.close();
            this.distribution.close();
        }

        /*
         * Unable to fully structure code
         */
        public String getTargetSpec(RoutingContext context, BucketId bucketId) {
            sendRandomReason = null;
            messageContext = new MessageContext(this.cachedClusterState);
            context.setContext((Object)messageContext);
            if (this.cachedClusterState != null) {
                try {
                    target = this.distribution.getIdealDistributorNode(this.cachedClusterState, bucketId, "uim");
                    if (this.persistentFailureChecker.tooManyFailures(target)) {
                        sendRandomReason = "Too many failures detected versus distributor " + target + ". Sending to random instead of using cached state.";
                        target = null;
                    }
                    if (target == null) ** GOTO lbl34
                    messageContext.calculatedDistributor = target;
                    targetSpec = this.hostFetcher.getTargetSpec(target, context);
                    if (targetSpec != null) {
                        if (context.shouldTrace(1)) {
                            context.trace(1, "Using distributor " + messageContext.calculatedDistributor + " for " + bucketId + " as our state version is " + this.cachedClusterState.getVersion());
                        }
                        messageContext.usedState = this.cachedClusterState;
                        return targetSpec;
                    }
                    sendRandomReason = "Want to use distributor " + messageContext.calculatedDistributor + " but it is not in slobrok. Sending to random.";
                    StoragePolicy.log.log((Level)LogLevel.DEBUG, "Target distributor is not in slobrok");
                }
                catch (Distribution.TooFewBucketBitsInUseException e) {
                    reply = new WrongDistributionReply(this.cachedClusterState.toString(true));
                    reply.addError(new Error(151002, "Too few distribution bits used for given cluster state"));
                    context.setReply((Reply)reply);
                    return null;
                }
                catch (Distribution.NoDistributorsAvailableException e) {
                    StoragePolicy.log.log((Level)LogLevel.DEBUG, "No distributors available; clearing cluster state");
                    this.cachedClusterState = null;
                    sendRandomReason = "No distributors available. Sending to random distributor.";
                }
            } else {
                sendRandomReason = "No cluster state cached. Sending to random distributor.";
            }
lbl34:
            // 4 sources

            if (context.shouldTrace(1)) {
                context.trace(1, (String)(sendRandomReason != null ? sendRandomReason : "Sending to random distributor for unknown reason"));
            }
            return this.hostFetcher.getRandomTargetSpec(context);
        }

        private static Optional<ClusterState> clusterStateFromReply(WrongDistributionReply reply) {
            try {
                return Optional.of(new ClusterState(reply.getSystemState()));
            }
            catch (Exception e) {
                reply.getTrace().trace(1, "Error when parsing system state string " + reply.getSystemState());
                return Optional.empty();
            }
        }

        public void handleWrongDistribution(WrongDistributionReply reply, RoutingContext routingContext) {
            MessageContext context = (MessageContext)routingContext.getContext();
            Optional<ClusterState> replyState = DistributorSelectionLogic.clusterStateFromReply(reply);
            if (!replyState.isPresent()) {
                return;
            }
            ClusterState newState = replyState.get();
            this.resetCachedStateIfClusterStateVersionLikelyRolledBack(newState);
            this.markReplyAsImmediateRetryIfNewStateObserved(reply, context, newState);
            if (context.calculatedDistributor == null) {
                this.traceReplyFromRandomDistributor(reply, newState);
            } else {
                this.traceReplyFromSpecificDistributor(reply, context, newState);
            }
            this.updateCachedRoutingStateFromWrongDistribution(context, newState);
        }

        private void updateCachedRoutingStateFromWrongDistribution(MessageContext context, ClusterState newState) {
            if (this.cachedClusterState == null || newState.getVersion() >= this.cachedClusterState.getVersion()) {
                this.cachedClusterState = newState;
                if (newState.getClusterState().equals((Object)State.UP)) {
                    this.hostFetcher.updateValidTargets(newState);
                }
            } else if (newState.getVersion() + 2000000000 < this.cachedClusterState.getVersion()) {
                this.cachedClusterState = null;
            } else if (context.calculatedDistributor != null) {
                this.persistentFailureChecker.addFailure(context.calculatedDistributor);
            }
        }

        private void traceReplyFromSpecificDistributor(WrongDistributionReply reply, MessageContext context, ClusterState newState) {
            if (context.usedState == null) {
                String msg = "Used state must be set as distributor is calculated. Bug.";
                reply.getTrace().trace(1, msg);
                log.log((Level)LogLevel.ERROR, msg);
            } else if (newState.getVersion() == context.usedState.getVersion()) {
                String msg = "Message sent to distributor " + context.calculatedDistributor + " retrieved cluster state version " + newState.getVersion() + " which was the state we used to calculate distributor as target last time.";
                reply.getTrace().trace(1, msg);
                log.log((Level)LogLevel.DEBUG, msg);
            } else if (newState.getVersion() > context.usedState.getVersion()) {
                if (reply.getTrace().shouldTrace(1)) {
                    reply.getTrace().trace(1, "Message sent to distributor " + context.calculatedDistributor + " updated cluster state from version " + context.usedState.getVersion() + " to " + newState.getVersion());
                }
            } else if (reply.getTrace().shouldTrace(1)) {
                reply.getTrace().trace(1, "Message sent to distributor " + context.calculatedDistributor + " returned older cluster state version " + newState.getVersion());
            }
        }

        private void resetCachedStateIfClusterStateVersionLikelyRolledBack(ClusterState newState) {
            if (this.cachedClusterState != null && this.cachedClusterState.getVersion() > newState.getVersion() && ++this.oldClusterVersionGottenCount >= this.maxOldClusterVersionBeforeSendingRandom) {
                this.oldClusterVersionGottenCount = 0;
                this.cachedClusterState = null;
            }
        }

        private void markReplyAsImmediateRetryIfNewStateObserved(WrongDistributionReply reply, MessageContext context, ClusterState newState) {
            if (context.usedState != null && newState.getVersion() <= context.usedState.getVersion()) {
                if (reply.getRetryDelay() <= 0.0) {
                    reply.setRetryDelay(-1.0);
                }
            } else if (reply.getRetryDelay() <= 0.0) {
                reply.setRetryDelay(0.0);
            }
        }

        private void traceReplyFromRandomDistributor(WrongDistributionReply reply, ClusterState newState) {
            if (!reply.getTrace().shouldTrace(1)) {
                return;
            }
            if (this.cachedClusterState == null) {
                reply.getTrace().trace(1, "Message sent to * with no previous state, received version " + newState.getVersion());
            } else if (newState.getVersion() == this.cachedClusterState.getVersion()) {
                reply.getTrace().trace(1, "Message sent to * found that cluster state version " + newState.getVersion() + " was correct.");
            } else if (newState.getVersion() > this.cachedClusterState.getVersion()) {
                reply.getTrace().trace(1, "Message sent to * updated cluster state to version " + newState.getVersion());
            } else {
                reply.getTrace().trace(1, "Message sent to * retrieved older cluster state version " + newState.getVersion());
            }
        }

        public void handleErrorReply(Reply reply, Object untypedContext) {
            MessageContext messageContext = (MessageContext)untypedContext;
            if (messageContext.calculatedDistributor != null) {
                this.persistentFailureChecker.addFailure(messageContext.calculatedDistributor);
                if (reply.getTrace().shouldTrace(1)) {
                    reply.getTrace().trace(1, "Failed with " + messageContext.toString());
                }
            }
        }

        private static class MessageContext {
            Integer calculatedDistributor;
            ClusterState usedState;

            public MessageContext(ClusterState usedState) {
                this.usedState = usedState;
            }

            public String toString() {
                return "Context(Distributor " + this.calculatedDistributor + ", state version " + this.usedState.getVersion() + ")";
            }
        }

        public static class InstabilityChecker {
            private List<Integer> nodeFailures = new ArrayList<Integer>();
            private int failureLimit;

            public InstabilityChecker(int failureLimit) {
                this.failureLimit = failureLimit;
            }

            public boolean tooManyFailures(int nodeIndex) {
                if (this.nodeFailures.size() > nodeIndex && this.nodeFailures.get(nodeIndex) > this.failureLimit) {
                    this.nodeFailures.set(nodeIndex, 0);
                    return true;
                }
                return false;
            }

            public void addFailure(Integer calculatedDistributor) {
                while (this.nodeFailures.size() <= calculatedDistributor) {
                    this.nodeFailures.add(0);
                }
                this.nodeFailures.set(calculatedDistributor, this.nodeFailures.get(calculatedDistributor) + 1);
            }
        }
    }

    public static class BucketIdCalculator {
        private static final BucketIdFactory factory = new BucketIdFactory();

        private BucketId getBucketId(Message msg) {
            switch (msg.getType()) {
                case 100004: {
                    return factory.getBucketId(((PutDocumentMessage)msg).getDocumentPut().getDocument().getId());
                }
                case 100003: {
                    return factory.getBucketId(((GetDocumentMessage)msg).getDocumentId());
                }
                case 100005: {
                    return factory.getBucketId(((RemoveDocumentMessage)msg).getDocumentId());
                }
                case 100006: {
                    return factory.getBucketId(((UpdateDocumentMessage)msg).getDocumentUpdate().getId());
                }
                case 100020: {
                    return ((GetBucketListMessage)msg).getBucketId();
                }
                case 100019: {
                    return ((StatBucketMessage)msg).getBucketId();
                }
                case 100007: {
                    return ((CreateVisitorMessage)msg).getBuckets().get(0);
                }
                case 100024: {
                    return ((RemoveLocationMessage)msg).getBucketId();
                }
            }
            log.log((Level)LogLevel.ERROR, "Message type '" + msg.getType() + "' not supported.");
            return null;
        }

        public BucketId handleBucketIdCalculation(RoutingContext context) {
            BucketId id = this.getBucketId(context.getMessage());
            if (id == null || id.getRawId() == 0L) {
                EmptyReply reply = new EmptyReply();
                reply.addError(new Error(250000, "No bucket id available in message."));
                context.setReply((Reply)reply);
            }
            return id;
        }
    }

    public static class Parameters {
        protected String clusterName = null;
        protected String distributionConfigId = null;
        protected SlobrokHostPatternGenerator slobrokHostPatternGenerator = null;

        public Parameters(Map<String, String> params) {
            this.clusterName = params.get("cluster");
            this.distributionConfigId = params.get("clusterconfigid");
            this.slobrokHostPatternGenerator = this.createPatternGenerator();
            if (this.clusterName == null) {
                throw new IllegalArgumentException("Required parameter cluster with clustername not set");
            }
        }

        public String getDistributionConfigId() {
            return this.distributionConfigId == null ? "storage/cluster." + this.clusterName : this.distributionConfigId;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public SlobrokHostPatternGenerator createPatternGenerator() {
            return new SlobrokHostPatternGenerator(this.getClusterName());
        }

        public HostFetcher createHostFetcher(ExternalSlobrokPolicy policy) {
            return new TargetCachingSlobrokHostFetcher(this.slobrokHostPatternGenerator, policy);
        }

        public Distribution createDistribution(ExternalSlobrokPolicy policy) {
            return policy.configSources != null ? new Distribution(this.getDistributionConfigId(), new ConfigSourceSet(policy.configSources)) : new Distribution(this.getDistributionConfigId());
        }

        public int getAttemptRandomOnFailuresLimit() {
            return 5;
        }

        public int maxOldClusterStatesSeenBeforeThrowingCachedState() {
            return 20;
        }

        public int getRequiredUpPercentageToSendToKnownGoodNodes() {
            return 60;
        }
    }

    static class TargetCachingSlobrokHostFetcher
    extends SlobrokHostFetcher {
        private volatile GenerationCache generationCache = null;

        TargetCachingSlobrokHostFetcher(SlobrokHostPatternGenerator patternGenerator, ExternalSlobrokPolicy policy) {
            super(patternGenerator, policy);
        }

        @Override
        public String getTargetSpec(Integer distributor, RoutingContext context) {
            GenerationCache cache = this.generationCache;
            int currentGeneration = this.getMirror(context).updates();
            if (cache == null || currentGeneration != cache.generation()) {
                this.generationCache = cache = new GenerationCache(currentGeneration);
            }
            if (distributor != null) {
                return this.cachingGetTargetSpec(distributor, context, cache);
            }
            return super.getTargetSpec(null, context);
        }

        private String cachingGetTargetSpec(Integer distributor, RoutingContext context, GenerationCache cache) {
            String cachedTarget = cache.get(distributor);
            if (cachedTarget != null) {
                return cachedTarget;
            }
            String resolvedTarget = super.getTargetSpec(distributor, context);
            cache.put(distributor, resolvedTarget);
            return resolvedTarget;
        }

        private static class GenerationCache {
            private final int generation;
            private final CopyOnWriteHashMap<Integer, String> targets = new CopyOnWriteHashMap();

            GenerationCache(int generation) {
                this.generation = generation;
            }

            public int generation() {
                return this.generation;
            }

            public String get(Integer index) {
                return (String)this.targets.get((Object)index);
            }

            public void put(Integer index, String target) {
                this.targets.put((Object)index, (Object)target);
            }
        }
    }

    public static class SlobrokHostFetcher
    extends HostFetcher {
        private final SlobrokHostPatternGenerator patternGenerator;
        ExternalSlobrokPolicy policy;

        public SlobrokHostFetcher(SlobrokHostPatternGenerator patternGenerator, ExternalSlobrokPolicy policy) {
            this.patternGenerator = patternGenerator;
            this.policy = policy;
        }

        private Mirror.Entry[] getEntries(String hostPattern, RoutingContext context) {
            return this.policy.lookup(context, hostPattern);
        }

        private String convertSlobrokNameToSessionName(String slobrokName) {
            return slobrokName + "/default";
        }

        public IMirror getMirror(RoutingContext context) {
            return context.getMirror();
        }

        @Override
        public String getTargetSpec(Integer distributor, RoutingContext context) {
            Mirror.Entry[] arr = this.getEntries(this.patternGenerator.getDistributorHostPattern(distributor), context);
            if (arr.length == 0) {
                return null;
            }
            if (distributor != null) {
                if (arr.length == 1) {
                    return this.convertSlobrokNameToSessionName(arr[0].getSpec());
                }
            } else {
                return this.convertSlobrokNameToSessionName(arr[this.randomizer.nextInt(arr.length)].getSpec());
            }
            log.log(LogLevel.WARNING, "Got " + arr.length + " matches for a distributor.");
            return null;
        }
    }

    public static abstract class HostFetcher {
        private int requiredUpPercentageToSendToKnownGoodNodes = 60;
        private List<Integer> validRandomTargets = new ArrayList<Integer>();
        private int totalTargets = 1;
        protected final Random randomizer = new Random(12345L);

        public void setRequiredUpPercentageToSendToKnownGoodNodes(int percent) {
            this.requiredUpPercentageToSendToKnownGoodNodes = percent;
        }

        public void updateValidTargets(ClusterState state) {
            ArrayList<Integer> validRandomTargets = new ArrayList<Integer>();
            for (int i = 0; i < state.getNodeCount(NodeType.DISTRIBUTOR); ++i) {
                if (!state.getNodeState(new Node(NodeType.DISTRIBUTOR, i)).getState().oneOf(StoragePolicy.upStates)) continue;
                validRandomTargets.add(i);
            }
            this.validRandomTargets = validRandomTargets;
            this.totalTargets = state.getNodeCount(NodeType.DISTRIBUTOR);
        }

        public abstract String getTargetSpec(Integer var1, RoutingContext var2);

        public String getRandomTargetSpec(RoutingContext context) {
            while (100 * this.validRandomTargets.size() / this.totalTargets >= this.requiredUpPercentageToSendToKnownGoodNodes) {
                int randIndex = this.randomizer.nextInt(this.validRandomTargets.size());
                String targetSpec = this.getTargetSpec(this.validRandomTargets.get(randIndex), context);
                if (targetSpec != null) {
                    context.trace(3, "Sending to random node seen up in cluster state");
                    return targetSpec;
                }
                this.validRandomTargets.remove(randIndex);
            }
            context.trace(3, "Too few nodes seen up in state. Sending totally random.");
            return this.getTargetSpec(null, context);
        }

        public void close() {
        }
    }

    public static class SlobrokHostPatternGenerator {
        private final String clusterName;

        public SlobrokHostPatternGenerator(String clusterName) {
            this.clusterName = clusterName;
        }

        public String getDistributorHostPattern(Integer distributor) {
            return "storage/cluster." + this.clusterName + "/distributor/" + (Serializable)(distributor == null ? "*" : distributor) + "/default";
        }
    }
}

