/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.DocumentAccessException;
import com.yahoo.documentapi.Response;
import com.yahoo.documentapi.Result;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.messagebus.MessageBusAsyncSession;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.MessageBusSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentReply;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Routable;
import java.time.Duration;

public class MessageBusSyncSession
implements MessageBusSession,
SyncSession,
ReplyHandler {
    private final MessageBusAsyncSession session;
    private final Duration defaultTimeout;

    MessageBusSyncSession(SyncParameters syncParams, MessageBus bus, MessageBusParams mbusParams) {
        this.session = new MessageBusAsyncSession(new AsyncParameters(), bus, mbusParams, this);
        this.defaultTimeout = syncParams.defaultTimeout().orElse(null);
    }

    public void handleReply(Reply reply) {
        if (reply.getContext() instanceof RequestMonitor) {
            ((RequestMonitor)reply.getContext()).replied(reply);
        } else {
            ReplyHandler handler = reply.getCallStack().pop((Routable)reply);
            handler.handleReply(reply);
        }
    }

    @Override
    public Response getNext() {
        throw new UnsupportedOperationException("Queue not supported.");
    }

    @Override
    public Response getNext(int timeout) {
        throw new UnsupportedOperationException("Queue not supported.");
    }

    @Override
    public void destroy() {
        this.session.destroy();
    }

    public Reply syncSend(Message msg) {
        return this.syncSend(msg, this.defaultTimeout);
    }

    private Reply syncSend(Message msg, Duration timeout) {
        if (timeout != null) {
            msg.setTimeRemaining(timeout.toMillis());
        }
        try {
            RequestMonitor monitor = new RequestMonitor();
            msg.setContext((Object)monitor);
            msg.pushHandler((ReplyHandler)this);
            Result result = null;
            while (!(result != null && result.type() != Result.ResultType.TRANSIENT_ERROR || (result = this.session.send(msg)) != null && result.isSuccess())) {
                Thread.sleep(100L);
            }
            if (!result.isSuccess()) {
                throw new DocumentAccessException(result.getError().toString());
            }
            return monitor.waitForReply();
        }
        catch (InterruptedException e) {
            throw new DocumentAccessException(e);
        }
    }

    @Override
    public void put(DocumentPut documentPut) {
        this.put(documentPut, DocumentProtocol.Priority.NORMAL_3);
    }

    @Override
    public void put(DocumentPut documentPut, DocumentProtocol.Priority priority) {
        PutDocumentMessage msg = new PutDocumentMessage(documentPut);
        msg.setPriority(priority);
        this.syncSendPutDocumentMessage(msg);
    }

    @Override
    public Document get(DocumentId id) {
        return this.get(id, null);
    }

    @Override
    public Document get(DocumentId id, String fieldSet, DocumentProtocol.Priority pri) {
        return this.get(id, fieldSet, pri, null);
    }

    @Override
    public Document get(DocumentId id, Duration timeout) {
        return this.get(id, "[all]", DocumentProtocol.Priority.NORMAL_1, timeout);
    }

    @Override
    public Document get(DocumentId id, String fieldSet, DocumentProtocol.Priority pri, Duration timeout) {
        GetDocumentMessage msg = new GetDocumentMessage(id, fieldSet);
        msg.setPriority(pri);
        Reply reply = this.syncSend(msg, timeout != null ? timeout : this.defaultTimeout);
        if (reply.hasErrors()) {
            throw new DocumentAccessException(MessageBusAsyncSession.getErrorMessage(reply));
        }
        if (reply.getType() != 200003) {
            throw new DocumentAccessException("Received unknown response: " + reply);
        }
        GetDocumentReply docReply = (GetDocumentReply)reply;
        Document doc = docReply.getDocument();
        if (doc != null) {
            doc.setLastModified(Long.valueOf(docReply.getLastModified()));
        }
        return doc;
    }

    @Override
    public boolean remove(DocumentRemove documentRemove) {
        RemoveDocumentMessage msg = new RemoveDocumentMessage(documentRemove.getId());
        msg.setCondition(documentRemove.getCondition());
        return this.remove(msg);
    }

    @Override
    public boolean remove(DocumentRemove documentRemove, DocumentProtocol.Priority pri) {
        RemoveDocumentMessage msg = new RemoveDocumentMessage(documentRemove.getId());
        msg.setPriority(pri);
        msg.setCondition(documentRemove.getCondition());
        return this.remove(msg);
    }

    private boolean remove(RemoveDocumentMessage msg) {
        Reply reply = this.syncSend(msg);
        if (reply.hasErrors()) {
            throw new DocumentAccessException(MessageBusAsyncSession.getErrorMessage(reply));
        }
        if (reply.getType() != 200005) {
            throw new DocumentAccessException("Received unknown response: " + reply);
        }
        return ((RemoveDocumentReply)reply).wasFound();
    }

    @Override
    public boolean update(DocumentUpdate update) {
        return this.update(update, DocumentProtocol.Priority.NORMAL_2);
    }

    @Override
    public boolean update(DocumentUpdate update, DocumentProtocol.Priority pri) {
        UpdateDocumentMessage msg = new UpdateDocumentMessage(update);
        msg.setPriority(pri);
        Reply reply = this.syncSend(msg);
        if (reply.hasErrors()) {
            throw new DocumentAccessException(MessageBusAsyncSession.getErrorMessage(reply), reply.getErrorCodes());
        }
        if (reply.getType() != 200006) {
            throw new DocumentAccessException("Received unknown response: " + reply);
        }
        return ((UpdateDocumentReply)reply).wasFound();
    }

    @Override
    public String getRoute() {
        return this.session.getRoute();
    }

    @Override
    public void setRoute(String route) {
        this.session.setRoute(route);
    }

    @Override
    public int getTraceLevel() {
        return this.session.getTraceLevel();
    }

    @Override
    public void setTraceLevel(int traceLevel) {
        this.session.setTraceLevel(traceLevel);
    }

    private void syncSendPutDocumentMessage(PutDocumentMessage putDocumentMessage) {
        Reply reply = this.syncSend(putDocumentMessage);
        if (reply.hasErrors()) {
            throw new DocumentAccessException(MessageBusAsyncSession.getErrorMessage(reply), reply.getErrorCodes());
        }
    }

    static class RequestMonitor {
        private Reply reply = null;

        RequestMonitor() {
        }

        synchronized Reply waitForReply() throws InterruptedException {
            while (this.reply == null) {
                this.wait();
            }
            return this.reply;
        }

        synchronized void replied(Reply reply) {
            this.reply = reply;
            this.notify();
        }
    }
}

