/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.collections.Tuple2;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentReply;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;

final class ReplyMerger {
    private Reply successReply = null;
    private int successIndex = -1;
    private Reply error = null;
    private Reply ignore = null;

    ReplyMerger() {
    }

    public void merge(int i, Reply r) {
        if (r.hasErrors()) {
            this.mergeAllReplyErrors(r);
        } else {
            this.updateStateWithSuccessfulReply(i, r);
        }
    }

    private boolean resourceWasFound(Reply r) {
        if (r instanceof RemoveDocumentReply) {
            return ((RemoveDocumentReply)r).wasFound();
        }
        if (r instanceof UpdateDocumentReply) {
            return ((UpdateDocumentReply)r).wasFound();
        }
        if (r instanceof GetDocumentReply) {
            return ((GetDocumentReply)r).getLastModified() > 0L;
        }
        return false;
    }

    private boolean replyIsBetterThanCurrent(Reply r) {
        return this.resourceWasFound(r) && !this.resourceWasFound(this.successReply);
    }

    private void updateStateWithSuccessfulReply(int i, Reply r) {
        if (this.successReply == null || this.replyIsBetterThanCurrent(r)) {
            this.setCurrentBestReply(i, r);
        }
    }

    private void setCurrentBestReply(int i, Reply r) {
        this.successReply = r;
        this.successIndex = i;
    }

    private void mergeAllReplyErrors(Reply r) {
        if (this.handleReplyWithOnlyIgnoredErrors(r)) {
            return;
        }
        if (this.error == null) {
            this.error = new EmptyReply();
            r.swapState((Routable)this.error);
            return;
        }
        for (int j = 0; j < r.getNumErrors(); ++j) {
            this.error.addError(r.getError(j));
        }
    }

    private boolean handleReplyWithOnlyIgnoredErrors(Reply r) {
        if (DocumentProtocol.hasOnlyErrorsOfType(r, 250001)) {
            if (this.ignore == null) {
                this.ignore = new EmptyReply();
            }
            this.ignore.addError(r.getError(0));
            return true;
        }
        return false;
    }

    private boolean shouldReturnErrorReply() {
        return this.error != null || this.ignore != null && this.successReply == null;
    }

    private Tuple2<Integer, Reply> createMergedErrorReplyResult() {
        if (this.error != null) {
            return new Tuple2(null, (Object)this.error);
        }
        if (this.ignore != null && this.successReply == null) {
            return new Tuple2(null, (Object)this.ignore);
        }
        throw new IllegalStateException("createMergedErrorReplyResult called without error");
    }

    private boolean successfullyMergedAtLeastOneReply() {
        return this.successReply != null;
    }

    private Tuple2<Integer, Reply> createEmptyReplyResult() {
        return new Tuple2(null, (Object)new EmptyReply());
    }

    public Tuple2<Integer, Reply> mergedReply() {
        if (this.shouldReturnErrorReply()) {
            return this.createMergedErrorReplyResult();
        }
        if (!this.successfullyMergedAtLeastOneReply()) {
            return this.createEmptyReplyResult();
        }
        return new Tuple2((Object)this.successIndex, (Object)this.successReply);
    }
}

