/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.document.DocumentOperation;
import com.yahoo.documentapi.AckToken;
import com.yahoo.documentapi.DocumentListVisitorResponse;
import com.yahoo.documentapi.VisitorDataHandler;
import com.yahoo.documentapi.VisitorResponse;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.messagebus.Message;
import com.yahoo.vdslib.DocumentList;
import com.yahoo.vdslib.Entry;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class VisitorDataQueue
extends VisitorDataHandler {
    private final BlockingQueue<VisitorResponse> pendingResponses = new LinkedBlockingQueue<VisitorResponse>();

    @Override
    public void reset() {
        super.reset();
        this.pendingResponses.clear();
    }

    private void appendSingleOpToPendingList(DocumentOperation op, AckToken token) {
        DocumentList docList = DocumentList.create((Entry)Entry.create((DocumentOperation)op));
        DocumentListVisitorResponse response = new DocumentListVisitorResponse(docList, token);
        this.pendingResponses.add(response);
    }

    @Override
    public void onMessage(Message m, AckToken token) {
        if (m instanceof PutDocumentMessage) {
            this.appendSingleOpToPendingList((DocumentOperation)((PutDocumentMessage)m).getDocumentPut(), token);
        } else if (m instanceof RemoveDocumentMessage) {
            this.appendSingleOpToPendingList((DocumentOperation)((RemoveDocumentMessage)m).getDocumentRemove(), token);
        } else {
            throw new UnsupportedOperationException(String.format("Expected put/remove message, got '%s' of type %s", m.toString(), m.getClass().toString()));
        }
    }

    @Deprecated
    public void onDocuments(DocumentList docs, AckToken token) {
        this.pendingResponses.add(new DocumentListVisitorResponse(docs, token));
    }

    @Override
    public VisitorResponse getNext() {
        return (VisitorResponse)this.pendingResponses.poll();
    }

    @Override
    public VisitorResponse getNext(int timeoutMilliseconds) throws InterruptedException {
        return this.pendingResponses.poll(timeoutMilliseconds, TimeUnit.MILLISECONDS);
    }
}

