/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.routing.RoutingContext;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public abstract class AsyncInitializationPolicy
implements DocumentProtocolRoutingPolicy,
Runnable {
    InitState initState = InitState.NOT_STARTED;
    ScheduledThreadPoolExecutor executor;
    Exception initException;
    boolean syncInit = true;

    public static Map<String, String> parse(String param) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (param != null) {
            String[] p;
            for (String s : p = param.split(";")) {
                String[] keyValue = s.split("=");
                if (keyValue.length == 1) {
                    map.put(keyValue[0], "true");
                    continue;
                }
                if (keyValue.length != 2) continue;
                map.put(keyValue[0], keyValue[1]);
            }
        }
        return map;
    }

    public AsyncInitializationPolicy(Map<String, String> params) {
    }

    public void needAsynchronousInitialization() {
        this.syncInit = false;
    }

    public abstract void init();

    public abstract void doSelect(RoutingContext var1);

    private synchronized void checkStartInit() {
        if (this.initState == InitState.NOT_STARTED) {
            if (this.syncInit) {
                this.init();
                this.initState = InitState.DONE;
            } else {
                this.executor = new ScheduledThreadPoolExecutor(1);
                this.executor.execute(this);
                this.initState = InitState.RUNNING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(RoutingContext routingContext) {
        AsyncInitializationPolicy asyncInitializationPolicy = this;
        synchronized (asyncInitializationPolicy) {
            if (this.initException != null) {
                EmptyReply reply = new EmptyReply();
                reply.addError(new Error(200013, this.initException.getMessage()));
                routingContext.setReply((Reply)reply);
                return;
            }
            this.checkStartInit();
            if (this.initState == InitState.RUNNING) {
                EmptyReply reply = new EmptyReply();
                reply.addError(new Error(100005, "Policy is waiting to be initialized."));
                routingContext.setReply((Reply)reply);
                return;
            }
        }
        this.doSelect(routingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.init();
        }
        catch (Exception e) {
            this.initException = e;
        }
        AsyncInitializationPolicy asyncInitializationPolicy = this;
        synchronized (asyncInitializationPolicy) {
            this.initState = InitState.DONE;
            this.notifyAll();
        }
    }

    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    protected static enum InitState {
        NOT_STARTED,
        RUNNING,
        DONE;

    }
}

