/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.local;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.Response;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.local.LocalDocumentAccess;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;

public class LocalSyncSession
implements SyncSession {
    private LocalDocumentAccess access;

    public LocalSyncSession(LocalDocumentAccess access) {
        this.access = access;
    }

    @Override
    public void put(DocumentPut documentPut) {
        if (documentPut.getCondition().isPresent()) {
            throw new UnsupportedOperationException("test-and-set is not supported.");
        }
        this.access.documents.put(documentPut.getId(), documentPut.getDocument());
    }

    @Override
    public void put(DocumentPut documentPut, DocumentProtocol.Priority priority) {
        this.access.documents.put(documentPut.getId(), documentPut.getDocument());
    }

    @Override
    public Document get(DocumentId id) {
        return this.access.documents.get(id);
    }

    @Override
    public Document get(DocumentId id, String fieldSet, DocumentProtocol.Priority pri) {
        return this.access.documents.get(id);
    }

    @Override
    public boolean remove(DocumentRemove documentRemove) {
        if (documentRemove.getCondition().isPresent()) {
            throw new UnsupportedOperationException("test-and-set is not supported.");
        }
        this.access.documents.remove(documentRemove.getId());
        return true;
    }

    @Override
    public boolean remove(DocumentRemove documentRemove, DocumentProtocol.Priority priority) {
        return this.remove(documentRemove);
    }

    @Override
    public boolean update(DocumentUpdate update) {
        Document document = this.access.documents.get(update.getId());
        if (document == null) {
            return false;
        }
        update.applyTo(document);
        return true;
    }

    @Override
    public boolean update(DocumentUpdate update, DocumentProtocol.Priority pri) {
        Document document = this.access.documents.get(update.getId());
        if (document == null) {
            return false;
        }
        update.applyTo(document);
        return true;
    }

    @Override
    public Response getNext() {
        throw new UnsupportedOperationException("Queue not supported.");
    }

    @Override
    public Response getNext(int timeout) {
        throw new UnsupportedOperationException("Queue not supported.");
    }

    @Override
    public void destroy() {
        this.access = null;
    }
}

