/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.ANDPolicy;
import com.yahoo.documentapi.messagebus.protocol.ContentPolicy;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.documentapi.messagebus.protocol.DocumentRouteSelectorPolicy;
import com.yahoo.documentapi.messagebus.protocol.ErrorPolicy;
import com.yahoo.documentapi.messagebus.protocol.ExternPolicy;
import com.yahoo.documentapi.messagebus.protocol.LoadBalancerPolicy;
import com.yahoo.documentapi.messagebus.protocol.LocalServicePolicy;
import com.yahoo.documentapi.messagebus.protocol.MessageTypePolicy;
import com.yahoo.documentapi.messagebus.protocol.RoundRobinPolicy;
import com.yahoo.documentapi.messagebus.protocol.RoutingPolicyFactory;
import com.yahoo.documentapi.messagebus.protocol.SearchColumnPolicy;
import com.yahoo.documentapi.messagebus.protocol.SearchRowPolicy;
import com.yahoo.documentapi.messagebus.protocol.StoragePolicy;
import com.yahoo.documentapi.messagebus.protocol.SubsetServicePolicy;

public abstract class RoutingPolicyFactories {

    static class SubsetServicePolicyFactory
    implements RoutingPolicyFactory {
        SubsetServicePolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new SubsetServicePolicy(param);
        }

        @Override
        public void destroy() {
        }
    }

    static class SearchRowPolicyFactory
    implements RoutingPolicyFactory {
        SearchRowPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new SearchRowPolicy(param);
        }

        @Override
        public void destroy() {
        }
    }

    static class SearchColumnPolicyFactory
    implements RoutingPolicyFactory {
        SearchColumnPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new SearchColumnPolicy(param);
        }

        @Override
        public void destroy() {
        }
    }

    static class LoadBalancerPolicyFactory
    implements RoutingPolicyFactory {
        LoadBalancerPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new LoadBalancerPolicy(param);
        }

        @Override
        public void destroy() {
        }
    }

    static class RoundRobinPolicyFactory
    implements RoutingPolicyFactory {
        RoundRobinPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new RoundRobinPolicy();
        }

        @Override
        public void destroy() {
        }
    }

    static class LocalServicePolicyFactory
    implements RoutingPolicyFactory {
        LocalServicePolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new LocalServicePolicy(param);
        }

        @Override
        public void destroy() {
        }
    }

    static class ExternPolicyFactory
    implements RoutingPolicyFactory {
        ExternPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            ExternPolicy ret = new ExternPolicy(param);
            String error = ret.getError();
            if (error != null) {
                return new ErrorPolicy(error);
            }
            return ret;
        }

        @Override
        public void destroy() {
        }
    }

    static class DocumentRouteSelectorPolicyFactory
    implements RoutingPolicyFactory {
        private final String configId;

        public DocumentRouteSelectorPolicyFactory(String configId) {
            this.configId = configId;
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            DocumentRouteSelectorPolicy ret = new DocumentRouteSelectorPolicy(param == null || param.isEmpty() ? this.configId : param);
            String error = ret.getError();
            if (error != null) {
                return new ErrorPolicy(error);
            }
            return ret;
        }

        @Override
        public void destroy() {
        }
    }

    static class MessageTypePolicyFactory
    implements RoutingPolicyFactory {
        private final String configId;

        public MessageTypePolicyFactory(String configId) {
            this.configId = configId;
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new MessageTypePolicy(param == null || param.isEmpty() ? this.configId : param);
        }

        @Override
        public void destroy() {
        }
    }

    static class ContentPolicyFactory
    implements RoutingPolicyFactory {
        ContentPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new ContentPolicy(param);
        }

        @Override
        public void destroy() {
        }
    }

    static class StoragePolicyFactory
    implements RoutingPolicyFactory {
        StoragePolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new StoragePolicy(param);
        }

        @Override
        public void destroy() {
        }
    }

    static class AndPolicyFactory
    implements RoutingPolicyFactory {
        AndPolicyFactory() {
        }

        @Override
        public DocumentProtocolRoutingPolicy createPolicy(String param) {
            return new ANDPolicy(param);
        }

        @Override
        public void destroy() {
        }
    }
}

