/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.ExternalSlobrokPolicy;
import com.yahoo.documentapi.messagebus.protocol.LoadBalancer;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.RoutingNodeIterator;
import java.util.Map;

public class LoadBalancerPolicy
extends ExternalSlobrokPolicy {
    String cluster = null;
    String session = null;
    private String pattern = null;
    LoadBalancer.Metrics metrics;
    LoadBalancer loadBalancer;

    public LoadBalancerPolicy(String param) {
        this(param, LoadBalancerPolicy.parse(param));
    }

    public LoadBalancerPolicy(String param, Map<String, String> params) {
        super(params);
        this.cluster = params.get("cluster");
        this.session = params.get("session");
        if (this.cluster == null) {
            this.error = "Required parameter pattern not set";
            return;
        }
        if (this.session == null) {
            this.error = "Required parameter session not set";
            return;
        }
        this.metrics = new LoadBalancer.Metrics(param);
        this.metrics.setXmlTagName("loadbalancer");
        this.pattern = this.cluster + "/*/" + this.session;
        this.loadBalancer = new LoadBalancer(this.cluster, this.session, this.metrics);
    }

    @Override
    public void doSelect(RoutingContext context) {
        LoadBalancer.Node node = this.getRecipient(context);
        if (node != null) {
            context.setContext((Object)node);
            Route route = new Route(context.getRoute());
            route.setHop(0, Hop.parse((String)(node.entry.getSpec() + "/" + this.session)));
            context.addChild(route);
        } else {
            context.setError(100002, "Could not resolve any nodes to send to in pattern " + this.pattern);
        }
    }

    LoadBalancer.Node getRecipient(RoutingContext context) {
        Mirror.Entry[] lastLookup = this.lookup(context, this.pattern);
        return this.loadBalancer.getRecipient(lastLookup);
    }

    public void merge(RoutingContext context) {
        RoutingNodeIterator it = context.getChildIterator();
        Reply reply = it.removeReply();
        LoadBalancer.Node target = (LoadBalancer.Node)context.getContext();
        boolean busy = false;
        for (int i = 0; i < reply.getNumErrors(); ++i) {
            if (reply.getError(i).getCode() != 100005) continue;
            busy = true;
        }
        this.loadBalancer.received(target, busy);
        context.setReply(reply);
    }

    @Override
    public MetricSet getMetrics() {
        return this.metrics;
    }
}

