/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.annotation.AnnotationReference;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.ReferenceFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.json.JsonSerializationHelper;
import com.yahoo.document.serialization.DocumentWriter;
import com.yahoo.vespa.objects.FieldBase;
import com.yahoo.vespa.objects.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;

public class JsonWriter
implements DocumentWriter {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonGenerator generator;

    public JsonWriter(OutputStream out) {
        this(JsonWriter.createPrivateGenerator(out));
    }

    private static JsonGenerator createPrivateGenerator(OutputStream out) {
        try {
            return jsonFactory.createGenerator(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonWriter(JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void write(FieldBase field, FieldValue value) {
        throw new UnsupportedOperationException("Serializing " + value.getClass().getName() + " is not supported.");
    }

    @Override
    public void write(FieldBase field, Document value) {
        try {
            JsonSerializationHelper.fieldNameIfNotNull(this.generator, field);
            this.generator.writeStartObject();
            this.generator.writeStringField("id", value.getId().toString());
            this.writeFields(value);
            this.generator.writeEndObject();
            this.generator.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends FieldValue> void write(FieldBase field, Array<T> value) {
        JsonSerializationHelper.serializeArrayField(this, this.generator, field, value);
    }

    @Override
    public <K extends FieldValue, V extends FieldValue> void write(FieldBase field, MapFieldValue<K, V> map) {
        JsonSerializationHelper.serializeMapField(this, this.generator, field, map);
    }

    @Override
    public void write(FieldBase field, ByteFieldValue value) {
        JsonSerializationHelper.serializeByteField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, BoolFieldValue value) {
        JsonSerializationHelper.serializeBoolField(this.generator, field, value);
    }

    @Override
    public <T extends FieldValue> void write(FieldBase field, CollectionFieldValue<T> value) {
        JsonSerializationHelper.serializeCollectionField(this, this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, DoubleFieldValue value) {
        JsonSerializationHelper.serializeDoubleField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, FloatFieldValue value) {
        JsonSerializationHelper.serializeFloatField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, IntegerFieldValue value) {
        JsonSerializationHelper.serializeIntField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, LongFieldValue value) {
        JsonSerializationHelper.serializeLongField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, Raw value) {
        JsonSerializationHelper.serializeRawField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, PredicateFieldValue value) {
        JsonSerializationHelper.serializePredicateField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, StringFieldValue value) {
        JsonSerializationHelper.serializeStringField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, TensorFieldValue value) {
        JsonSerializationHelper.serializeTensorField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, ReferenceFieldValue value) {
        JsonSerializationHelper.serializeReferenceField(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, Struct value) {
        JsonSerializationHelper.serializeStructField(this, this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, StructuredFieldValue value) {
        JsonSerializationHelper.serializeStructuredField(this, this.generator, field, value);
    }

    @Override
    public <T extends FieldValue> void write(FieldBase field, WeightedSet<T> value) {
        JsonSerializationHelper.serializeWeightedSet(this.generator, field, value);
    }

    @Override
    public void write(FieldBase field, AnnotationReference value) {
    }

    @Override
    public void write(Document document) {
        this.write(null, document);
    }

    @Override
    public void write(DocumentId id) {
    }

    @Override
    public void write(DocumentType type) {
    }

    public static byte[] toByteArray(Document document) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonWriter writer = new JsonWriter(out);
        writer.write(document);
        return out.toByteArray();
    }

    public static byte[] documentRemove(DocumentId docId) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            JsonGenerator throwAway = jsonFactory.createGenerator((OutputStream)out);
            throwAway.writeStartObject();
            throwAway.writeStringField("remove", docId.toString());
            throwAway.writeEndObject();
            throwAway.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public Serializer putByte(FieldBase field, byte value) {
        JsonSerializationHelper.serializeByte(this.generator, field, value);
        return this;
    }

    public Serializer putShort(FieldBase field, short value) {
        JsonSerializationHelper.serializeShort(this.generator, field, value);
        return this;
    }

    public Serializer putInt(FieldBase field, int value) {
        JsonSerializationHelper.serializeInt(this.generator, field, value);
        return this;
    }

    public Serializer putLong(FieldBase field, long value) {
        JsonSerializationHelper.serializeLong(this.generator, field, value);
        return this;
    }

    public Serializer putFloat(FieldBase field, float value) {
        JsonSerializationHelper.serializeFloat(this.generator, field, value);
        return this;
    }

    public Serializer putDouble(FieldBase field, double value) {
        JsonSerializationHelper.serializeDouble(this.generator, field, value);
        return this;
    }

    public Serializer put(FieldBase field, byte[] value) {
        JsonSerializationHelper.serializeByteArray(this.generator, field, value);
        return this;
    }

    public Serializer put(FieldBase field, ByteBuffer value) {
        JsonSerializationHelper.serializeByteBuffer(this.generator, field, value);
        return this;
    }

    public Serializer put(FieldBase field, String value) {
        JsonSerializationHelper.serializeString(this.generator, field, value);
        return this;
    }

    public void writeFields(Document value) throws IOException {
        this.generator.writeObjectFieldStart("fields");
        Iterator<Map.Entry<Field, FieldValue>> i = value.iterator();
        while (i.hasNext()) {
            Map.Entry<Field, FieldValue> entry = i.next();
            entry.getValue().serialize(entry.getKey(), this);
        }
        this.generator.writeEndObject();
    }
}

