/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;
import java.util.Objects;

public class PredicateFieldValue
extends FieldValue {
    private Predicate predicate;

    public PredicateFieldValue() {
        this((Predicate)null);
    }

    public PredicateFieldValue(Predicate predicate) {
        this.predicate = predicate;
    }

    public PredicateFieldValue(String predicateString) {
        this(Predicate.fromString((String)predicateString));
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public PredicateFieldValue setPredicate(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public DataType getDataType() {
        return DataType.PREDICATE;
    }

    @Override
    public void printXml(XmlStream xml) {
        if (this.predicate == null) {
            return;
        }
        xml.addContent(this.predicate.toString());
    }

    @Override
    public void clear() {
        this.predicate = null;
    }

    @Override
    public void assign(Object o) {
        if (o == null) {
            this.predicate = null;
        } else if (o instanceof Predicate) {
            this.predicate = (Predicate)o;
        } else if (o instanceof PredicateFieldValue) {
            this.predicate = ((PredicateFieldValue)o).predicate;
        } else {
            throw new IllegalArgumentException("Expected " + this.getClass().getName() + ", got " + o.getClass().getName() + ".");
        }
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public Object getWrappedValue() {
        return this.predicate;
    }

    @Override
    public PredicateFieldValue clone() {
        PredicateFieldValue obj = (PredicateFieldValue)super.clone();
        if (this.predicate != null) {
            try {
                obj.predicate = this.predicate.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
        return obj;
    }

    public int hashCode() {
        return this.predicate != null ? this.predicate.hashCode() : 31;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PredicateFieldValue)) {
            return false;
        }
        PredicateFieldValue rhs = (PredicateFieldValue)obj;
        return Objects.equals(this.predicate, rhs.predicate);
    }

    public String toString() {
        return String.valueOf(this.predicate);
    }

    public static PrimitiveDataType.Factory getFactory() {
        return new PrimitiveDataType.Factory(){

            @Override
            public FieldValue create() {
                return new PredicateFieldValue();
            }
        };
    }
}

