/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespaxmlparser;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.vespaxmlparser.DocumentFeedOperation;
import com.yahoo.vespaxmlparser.DocumentUpdateFeedOperation;
import com.yahoo.vespaxmlparser.FeedOperation;
import com.yahoo.vespaxmlparser.FeedReader;
import com.yahoo.vespaxmlparser.RemoveFeedOperation;
import com.yahoo.vespaxmlparser.VespaXMLDocumentReader;
import com.yahoo.vespaxmlparser.VespaXMLReader;
import com.yahoo.vespaxmlparser.VespaXMLUpdateReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class VespaXMLFeedReader
extends VespaXMLReader
implements FeedReader {
    public VespaXMLFeedReader(String fileName, DocumentTypeManager docTypeManager) throws Exception {
        super(fileName, docTypeManager);
        this.readInitial();
    }

    public VespaXMLFeedReader(InputStream stream, DocumentTypeManager docTypeManager) throws Exception {
        super(stream, docTypeManager);
        this.readInitial();
    }

    public VespaXMLFeedReader(XMLStreamReader reader, DocumentTypeManager manager) throws Exception {
        super(reader, manager);
        this.readInitial();
    }

    private void readInitial() throws Exception {
        boolean found = false;
        while (this.reader.hasNext()) {
            int type = this.reader.next();
            if (type != 1 || !"vespafeed".equals(this.reader.getName().toString())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw this.newDeserializeException("Feed information must be contained within a \"vespafeed\" element");
        }
    }

    public List<FeedOperation> readAll() throws Exception {
        ArrayList<FeedOperation> list = new ArrayList<FeedOperation>();
        FeedOperation op;
        while ((op = this.read()).getType() != FeedOperation.Type.INVALID) {
            list.add(op);
        }
        return list;
    }

    @Override
    public FeedOperation read() throws Exception {
        String startTag = null;
        try {
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                if (type != 1) continue;
                startTag = this.reader.getName().toString();
                if ("document".equals(startTag)) {
                    VespaXMLDocumentReader documentReader = new VespaXMLDocumentReader(this.reader, this.docTypeManager);
                    Document document = new Document(documentReader);
                    return new DocumentFeedOperation(document, TestAndSetCondition.fromConditionString(documentReader.getCondition()));
                }
                if ("update".equals(startTag)) {
                    VespaXMLUpdateReader updateReader = new VespaXMLUpdateReader(this.reader, this.docTypeManager);
                    DocumentUpdate update = new DocumentUpdate(updateReader);
                    return new DocumentUpdateFeedOperation(update, TestAndSetCondition.fromConditionString(updateReader.getCondition()));
                }
                if ("remove".equals(startTag)) {
                    DocumentId documentId = null;
                    Optional<String> condition = Optional.empty();
                    for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                        String attributeName = this.reader.getAttributeName(i).toString();
                        if ("documentid".equals(attributeName) || "id".equals(attributeName)) {
                            documentId = new DocumentId(this.reader.getAttributeValue(i));
                            continue;
                        }
                        if (!"condition".equals(attributeName)) continue;
                        condition = Optional.of(this.reader.getAttributeValue(i));
                    }
                    if (documentId == null) {
                        throw this.newDeserializeException("Missing \"documentid\" attribute for remove operation");
                    }
                    return new RemoveFeedOperation(documentId, TestAndSetCondition.fromConditionString(condition));
                }
                throw this.newDeserializeException("Element \"" + startTag + "\" not allowed in this context");
            }
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (startTag != null) {
                    this.skipToEnd(startTag);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        return FeedOperation.INVALID;
    }
}

