/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;

public final class Float16FieldValue
extends NumericFieldValue {
    public static final int classId = Float16FieldValue.registerClass((int)4114, Float16FieldValue.class);
    private float value;

    public static PrimitiveDataType.Factory getFactory() {
        return new Factory();
    }

    public Float16FieldValue() {
        this(0.0f);
    }

    public Float16FieldValue(float value) {
        this.value = value;
    }

    public Float16FieldValue(Float value) {
        this.value = value.floatValue();
    }

    public Float16FieldValue(String s) {
        this.value = Float.parseFloat(s);
    }

    @Override
    public Float16FieldValue clone() {
        Float16FieldValue val = (Float16FieldValue)super.clone();
        val.value = this.value;
        return val;
    }

    @Override
    public Number getNumber() {
        return Float.valueOf(this.value);
    }

    @Override
    public void clear() {
        this.value = 0.0f;
    }

    @Override
    public void assign(Object obj) {
        if (!this.checkAssign(obj)) {
            return;
        }
        if (obj instanceof Number) {
            this.value = ((Number)obj).floatValue();
        } else if (obj instanceof NumericFieldValue) {
            this.value = ((NumericFieldValue)obj).getNumber().floatValue();
        } else if (obj instanceof String || obj instanceof StringFieldValue) {
            this.value = Float.parseFloat(obj.toString());
        } else {
            throw new IllegalArgumentException("Class " + obj.getClass() + " not applicable to an " + this.getClass() + " instance.");
        }
    }

    public float getFloat() {
        return this.value;
    }

    @Override
    public Object getWrappedValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT16;
    }

    @Override
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printShortfloatXml(this, xml);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != 0.0f ? Float.floatToIntBits(this.value) : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Float16FieldValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float16FieldValue that = (Float16FieldValue)o;
        return Float.compare(that.value, this.value) == 0;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        return Float.compare(this.value, ((Float16FieldValue)fieldValue).value);
    }

    private static class Factory
    extends PrimitiveDataType.Factory {
        private Factory() {
        }

        @Override
        public FieldValue create() {
            return new Float16FieldValue();
        }
    }
}

