/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentId;
import com.yahoo.document.Field;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;
import java.util.Objects;
import java.util.Optional;

public class ReferenceFieldValue
extends FieldValue {
    public static final int classId = ReferenceFieldValue.registerClass((int)4135, ReferenceFieldValue.class);
    private final ReferenceDataType referenceType;
    private Optional<DocumentId> documentId;

    public ReferenceFieldValue(ReferenceDataType referenceType) {
        this.referenceType = referenceType;
        this.documentId = Optional.empty();
    }

    public ReferenceFieldValue(ReferenceDataType referenceType, DocumentId documentId) {
        ReferenceFieldValue.requireIdOfMatchingType(referenceType, documentId);
        this.referenceType = referenceType;
        this.documentId = Optional.of(documentId);
    }

    public static ReferenceFieldValue createEmptyWithType(ReferenceDataType referenceType) {
        return new ReferenceFieldValue(referenceType);
    }

    private static void requireIdOfMatchingType(ReferenceDataType referenceType, DocumentId id) {
        String expectedTypeName = referenceType.getTargetType().getName();
        if (!id.getDocType().equals(expectedTypeName)) {
            throw new IllegalArgumentException(String.format("Can't assign document ID '%s' (of type '%s') to reference of document type '%s'", id, id.getDocType(), expectedTypeName));
        }
    }

    @Override
    public DataType getDataType() {
        return this.referenceType;
    }

    public Optional<DocumentId> getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(DocumentId documentId) {
        ReferenceFieldValue.requireIdOfMatchingType(this.referenceType, documentId);
        this.documentId = Optional.of(documentId);
    }

    @Override
    public void printXml(XmlStream xml) {
    }

    @Override
    public void clear() {
        this.documentId = Optional.empty();
    }

    @Override
    public void assign(Object o) {
        if (o == null) {
            this.clear();
        } else if (o instanceof ReferenceFieldValue) {
            this.assignFromFieldValue((ReferenceFieldValue)o);
        } else if (o instanceof DocumentId) {
            this.setDocumentId((DocumentId)o);
        } else {
            throw new IllegalArgumentException(String.format("Can't assign value of type '%s' to field of type '%s'. Expected value of type '%s'", o.getClass().getName(), this.getClass().getName(), DocumentId.class.getName()));
        }
    }

    private void assignFromFieldValue(ReferenceFieldValue rhs) {
        if (!this.getDataType().equals(rhs.getDataType())) {
            throw new IllegalArgumentException(String.format("Can't assign reference of type %s to reference of type %s", rhs.getDataType().getName(), this.getDataType().getName()));
        }
        rhs.getDocumentId().ifPresent(this::setDocumentId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReferenceFieldValue that = (ReferenceFieldValue)o;
        return Objects.equals(this.referenceType, that.referenceType) && Objects.equals(this.documentId, that.documentId);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.referenceType, this.documentId);
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public DocumentId getWrappedValue() {
        return this.documentId.orElse(null);
    }
}

