/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.serialization.DocumentSerializerFactory;
import com.yahoo.document.serialization.DocumentUpdateReader;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.io.GrowableByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class DocumentUpdate
extends DocumentOperation
implements Iterable<FieldPathUpdate> {
    public static final int CLASSID = 4102;
    private DocumentId docId;
    private List<FieldUpdate> fieldUpdates;
    private List<FieldPathUpdate> fieldPathUpdates;
    private DocumentType documentType;
    private Optional<Boolean> createIfNonExistent = Optional.empty();

    public DocumentUpdate(DocumentType docType, DocumentId docId) {
        this(docType, docId, new ArrayList<FieldUpdate>());
    }

    public DocumentUpdate(DocumentUpdateReader reader) {
        this.docId = null;
        this.documentType = null;
        this.fieldUpdates = new ArrayList<FieldUpdate>();
        this.fieldPathUpdates = new ArrayList<FieldPathUpdate>();
        reader.read(this);
    }

    public DocumentUpdate(DocumentType docType, String docId) {
        this(docType, new DocumentId(docId));
    }

    private DocumentUpdate(DocumentType docType, DocumentId docId, List<FieldUpdate> fieldUpdates) {
        this.docId = docId;
        this.documentType = docType;
        this.fieldUpdates = fieldUpdates;
        this.fieldPathUpdates = new ArrayList<FieldPathUpdate>();
    }

    @Override
    public DocumentId getId() {
        return this.docId;
    }

    public void setId(DocumentId id) {
        this.docId = id;
    }

    public DocumentUpdate applyTo(Document doc) {
        if (!this.documentType.equals(doc.getDataType())) {
            throw new IllegalArgumentException("Document " + doc + " must have same type as update, which is type " + this.documentType);
        }
        for (FieldUpdate fieldUpdate : this.fieldUpdates) {
            fieldUpdate.applyTo(doc);
        }
        for (FieldPathUpdate fieldPathUpdate : this.fieldPathUpdates) {
            fieldPathUpdate.applyTo(doc);
        }
        return this;
    }

    public List<FieldUpdate> getFieldUpdates() {
        return Collections.unmodifiableList(this.fieldUpdates);
    }

    public List<FieldPathUpdate> getFieldPathUpdates() {
        return Collections.unmodifiableList(this.fieldPathUpdates);
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType type) {
        this.documentType = type;
    }

    public FieldUpdate getFieldUpdate(int index) {
        return this.fieldUpdates.get(index);
    }

    public FieldUpdate setFieldUpdate(int index, FieldUpdate upd) {
        return this.fieldUpdates.set(index, upd);
    }

    public FieldUpdate getFieldUpdate(Field field) {
        return this.getFieldUpdate(field.getName());
    }

    public void clearFieldUpdates() {
        this.fieldUpdates.clear();
    }

    public FieldUpdate getFieldUpdate(String fieldName) {
        for (FieldUpdate fieldUpdate : this.fieldUpdates) {
            if (!fieldUpdate.getField().getName().equals(fieldName)) continue;
            return fieldUpdate;
        }
        return null;
    }

    public void setFieldUpdates(List<FieldUpdate> fieldUpdates) {
        if (fieldUpdates == null) {
            throw new NullPointerException("The field updates of a document update can not be null");
        }
        this.fieldUpdates = fieldUpdates;
    }

    public int size() {
        return this.fieldUpdates.size();
    }

    public DocumentUpdate addFieldUpdate(FieldUpdate update) {
        String fieldName = update.getField().getName();
        if (!this.documentType.hasField(fieldName)) {
            throw new IllegalArgumentException("Document type '" + this.documentType.getName() + "' does not have field '" + fieldName + "'.");
        }
        FieldUpdate prevUpdate = this.getFieldUpdate(fieldName);
        if (prevUpdate != update) {
            if (prevUpdate != null) {
                prevUpdate.addAll(update);
            } else {
                this.fieldUpdates.add(update);
            }
        }
        return this;
    }

    public DocumentUpdate addFieldPathUpdate(FieldPathUpdate fieldPathUpdate) {
        this.fieldPathUpdates.add(fieldPathUpdate);
        return this;
    }

    public void addFieldUpdateNoCheck(FieldUpdate fieldUpdate) {
        this.fieldUpdates.add(fieldUpdate);
    }

    public void addAll(DocumentUpdate update) {
        if (update == null) {
            return;
        }
        if (!this.docId.equals(update.docId)) {
            throw new IllegalArgumentException("Expected " + this.docId + ", got " + update.docId + ".");
        }
        if (!this.documentType.equals(update.documentType)) {
            throw new IllegalArgumentException("Expected " + this.documentType + ", got " + update.documentType + ".");
        }
        for (FieldUpdate fieldUpd : update.fieldUpdates) {
            this.addFieldUpdate(fieldUpd);
        }
        for (FieldPathUpdate pathUpd : update.fieldPathUpdates) {
            this.addFieldPathUpdate(pathUpd);
        }
    }

    public FieldUpdate removeFieldUpdate(int index) {
        return this.fieldUpdates.remove(index);
    }

    public DocumentType getType() {
        return this.documentType;
    }

    public final void serialize(GrowableByteBuffer buf) {
        this.serialize(DocumentSerializerFactory.create42(buf));
    }

    public void serialize(DocumentUpdateWriter data) {
        data.write(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentUpdate)) {
            return false;
        }
        DocumentUpdate that = (DocumentUpdate)o;
        if (this.docId != null ? !this.docId.equals(that.docId) : that.docId != null) {
            return false;
        }
        if (this.documentType != null ? !this.documentType.equals(that.documentType) : that.documentType != null) {
            return false;
        }
        if (this.fieldPathUpdates != null ? !this.fieldPathUpdates.equals(that.fieldPathUpdates) : that.fieldPathUpdates != null) {
            return false;
        }
        if (this.fieldUpdates != null ? !this.fieldUpdates.equals(that.fieldUpdates) : that.fieldUpdates != null) {
            return false;
        }
        return this.getCreateIfNonExistent() == ((DocumentUpdate)o).getCreateIfNonExistent();
    }

    public int hashCode() {
        int result = this.docId != null ? this.docId.hashCode() : 0;
        result = 31 * result + (this.fieldUpdates != null ? this.fieldUpdates.hashCode() : 0);
        result = 31 * result + (this.fieldPathUpdates != null ? this.fieldPathUpdates.hashCode() : 0);
        result = 31 * result + (this.documentType != null ? this.documentType.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("update of document '");
        string.append(this.docId);
        string.append("': ");
        string.append("create-if-non-existent=");
        string.append(this.createIfNonExistent.orElse(false));
        string.append(": ");
        string.append("[");
        Iterator<FieldUpdate> i = this.fieldUpdates.iterator();
        while (i.hasNext()) {
            FieldUpdate fieldUpdate = i.next();
            string.append(fieldUpdate);
            if (!i.hasNext()) continue;
            string.append(", ");
        }
        string.append("]");
        if (this.fieldPathUpdates.size() > 0) {
            string.append(" [ ");
            for (FieldPathUpdate up : this.fieldPathUpdates) {
                string.append(up.toString() + " ");
            }
            string.append(" ]");
        }
        return string.toString();
    }

    @Override
    public Iterator<FieldPathUpdate> iterator() {
        return this.fieldPathUpdates.iterator();
    }

    public boolean isEmpty() {
        return this.fieldUpdates.isEmpty() && this.fieldPathUpdates.isEmpty();
    }

    public void setCreateIfNonExistent(boolean value) {
        this.createIfNonExistent = Optional.of(value);
    }

    public boolean getCreateIfNonExistent() {
        return this.createIfNonExistent.orElse(false);
    }

    public Optional<Boolean> getOptionalCreateIfNonExistent() {
        return this.createIfNonExistent;
    }
}

