/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.collections.CollectionComparator;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.MapDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class WeightedSet<K extends FieldValue>
extends CollectionFieldValue<K>
implements Map<K, Integer> {
    private MapFieldValue<K, IntegerFieldValue> map;

    public WeightedSet(DataType type) {
        this(type, 1);
    }

    public WeightedSet(DataType type, int initialCapacity) {
        super((WeightedSetDataType)type);
        this.clearAndReserve(initialCapacity);
    }

    @Override
    public WeightedSetDataType getDataType() {
        return (WeightedSetDataType)super.getDataType();
    }

    @Override
    public Iterator<K> fieldValueIterator() {
        return this.map.keySet().iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void assign(Object o) {
        if (!this.checkAssign(o)) {
            return;
        }
        if (o instanceof WeightedSet) {
            WeightedSet wset = (WeightedSet)o;
            if (!this.getDataType().equals(wset.getDataType())) throw new IllegalArgumentException("Cannot assign a weighted set of type " + wset.getDataType() + " to a weighted set of type " + this.getDataType());
            this.map.assign(wset.map);
            return;
        } else {
            if (!(o instanceof Map)) throw new IllegalArgumentException("Class " + o.getClass() + " not applicable to an " + this.getClass() + " instance.");
            this.map = new WeightedSetWrapper((Map)o, this.map.getDataType());
        }
    }

    @Override
    public WeightedSet clone() {
        WeightedSet newSet = (WeightedSet)super.clone();
        newSet.map = this.map.clone();
        return newSet;
    }

    @Override
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printWeightedSetXml(this, xml);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean add(K value) {
        this.put(value, 1);
        return true;
    }

    @Override
    public Object getWrappedValue() {
        if (this.map instanceof WeightedSetWrapper) {
            return ((WeightedSetWrapper)this.map).map;
        }
        return this.map.getWrappedValue();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.keySet().contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<K> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean removeValue(FieldValue o) {
        return super.removeValue(o, this.map.keySet());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Integer get(Object key) {
        if (!(key instanceof FieldValue)) {
            throw new IllegalArgumentException("Only FieldValues are allowed as keys.");
        }
        IntegerFieldValue ifv = (IntegerFieldValue)this.map.get(key);
        return ifv != null ? Integer.valueOf(ifv.getInteger()) : null;
    }

    @Override
    public Integer put(K key, Integer weight) {
        this.verifyElementCompatibility(key);
        IntegerFieldValue ifv = this.putUnChecked(key, new IntegerFieldValue(weight));
        return ifv != null ? Integer.valueOf(ifv.getInteger()) : null;
    }

    public IntegerFieldValue putUnChecked(K key, IntegerFieldValue weight) {
        return this.map.put(key, weight);
    }

    @Override
    public Integer remove(Object key) {
        IntegerFieldValue ifv = (IntegerFieldValue)this.map.remove(key);
        return ifv != null ? Integer.valueOf(ifv.getInteger()) : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> t) {
        for (Map.Entry<K, Integer> entry : t.entrySet()) {
            this.put((K)((FieldValue)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void clearAndReserve(int count) {
        this.map = new MapFieldValue(new MapDataType(this.getDataType().getNestedType(), DataType.INT), count);
    }

    Map<K, Integer> getPrimitiveMap() {
        LinkedHashMap<K, Integer> retVal = new LinkedHashMap<K, Integer>();
        for (Map.Entry<K, IntegerFieldValue> entry : this.map.entrySet()) {
            retVal.put(entry.getKey(), entry.getValue().getInteger());
        }
        return retVal;
    }

    @Override
    public Collection<Integer> values() {
        return this.getPrimitiveMap().values();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, Integer>> entrySet() {
        return this.getPrimitiveMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof WeightedSet)) {
            return false;
        }
        WeightedSet otherSet = (WeightedSet)o;
        return super.equals(o) && this.map.equals(otherSet.map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WeightedSet(").append(this.getDataType());
        for (Map.Entry<K, IntegerFieldValue> entry : this.map.entrySet()) {
            sb.append("\n  key:   ").append(entry.getKey().getClass()).append(": ").append(entry.getKey());
            sb.append("\n  value: ").append(entry.getValue().getClass()).append(": ").append(entry.getValue());
        }
        return sb.append("\n)").toString();
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    FieldPathIteratorHandler.ModificationStatus iterateNested(FieldPath fieldPath, int pos, FieldPathIteratorHandler handler) {
        FieldPathIteratorHandler.ModificationStatus status = this.map.iterateNested(fieldPath, pos, handler, this);
        return status;
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        WeightedSet otherValue = (WeightedSet)fieldValue;
        comp = CollectionComparator.compare(this.map.keySet(), otherValue.map.keySet());
        if (comp != 0) {
            return comp;
        }
        return CollectionComparator.compare(this.map.values(), otherValue.map.values());
    }

    class WeightedSetWrapper
    extends MapFieldValue<K, IntegerFieldValue> {
        Map<Object, Integer> map;
        private DataType keyTypeVespa;
        private DataType valTypeVespa;

        public WeightedSetWrapper(Map map, MapDataType dt) {
            super(dt);
            this.map = new HashMap<Object, Integer>();
            this.keyTypeVespa = this.getDataType().getKeyType();
            this.valTypeVespa = DataType.INT;
            this.map = map;
        }

        private Object unwrap(Object o) {
            return o instanceof FieldValue ? ((FieldValue)o).getWrappedValue() : o;
        }

        private K wrapKey(Object o) {
            if (o == null) {
                return null;
            }
            return this.keyTypeVespa.createFieldValue(o);
        }

        private IntegerFieldValue wrapValue(Object o) {
            if (o == null) {
                return null;
            }
            return (IntegerFieldValue)this.valTypeVespa.createFieldValue(o);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(this.unwrap(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(this.unwrap(value));
        }

        @Override
        public Set<Map.Entry<K, IntegerFieldValue>> entrySet() {
            HashMap ret = new HashMap();
            for (Map.Entry<Object, Integer> e : this.map.entrySet()) {
                ret.put(this.wrapKey(e.getKey()), this.wrapValue(e.getValue()));
            }
            return ret.entrySet();
        }

        @Override
        public IntegerFieldValue get(Object key) {
            Integer o = this.map.get(this.unwrap(key));
            return o == null ? null : this.wrapValue(o);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            HashSet ret = new HashSet();
            for (Map.Entry<Object, Integer> e : this.map.entrySet()) {
                ret.add(this.wrapKey(e.getKey()));
            }
            return ret;
        }

        @Override
        public IntegerFieldValue put(FieldValue key, IntegerFieldValue value) {
            IntegerFieldValue old = this.get(key);
            this.map.put(this.unwrap(key), (Integer)this.unwrap(value));
            return old;
        }

        @Override
        public void putAll(Map<? extends K, ? extends IntegerFieldValue> m) {
            for (Map.Entry e : m.entrySet()) {
                this.map.put(this.unwrap(e.getKey()), (Integer)this.unwrap(e.getValue()));
            }
        }

        @Override
        public IntegerFieldValue remove(Object key) {
            return this.wrapValue(this.map.remove(this.unwrap(key)));
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<IntegerFieldValue> values() {
            ArrayList<IntegerFieldValue> ret = new ArrayList<IntegerFieldValue>();
            for (Integer v : this.map.values()) {
                ret.add(this.wrapValue(v));
            }
            return ret;
        }
    }
}

