/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.collections.Hashlet;
import com.yahoo.compress.CompressionType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Struct
extends StructuredFieldValue {
    public static final int classId = Struct.registerClass((int)4129, Struct.class);
    private Hashlet<Integer, FieldValue> values = new Hashlet();
    private int[] order = null;
    private int version = 8;

    private int[] getInOrder() {
        if (this.order == null) {
            this.order = new int[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                this.order[i] = (Integer)this.values.key(i);
            }
            Arrays.sort(this.order);
        }
        return this.order;
    }

    private void invalidateOrder() {
        this.order = null;
    }

    public Struct(DataType type) {
        super((StructDataType)type);
    }

    @Override
    public StructDataType getDataType() {
        return (StructDataType)super.getDataType();
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public CompressionType getCompressionType() {
        if (this.getDataType().getCompressionConfig() == null) {
            return CompressionType.NONE;
        }
        return this.getDataType().getCompressionConfig().type;
    }

    public int getCompressionLevel() {
        if (this.getDataType().getCompressionConfig() == null) {
            return 9;
        }
        return this.getDataType().getCompressionConfig().compressionLevel;
    }

    public float getCompressionThreshold() {
        if (this.getDataType().getCompressionConfig() == null) {
            return 0.95f;
        }
        return this.getDataType().getCompressionConfig().threshold;
    }

    @Override
    public Struct clone() {
        Struct struct = (Struct)super.clone();
        struct.values = new Hashlet();
        struct.values.reserve(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            struct.values.put(this.values.key(i), (Object)((FieldValue)this.values.value(i)).clone());
        }
        return struct;
    }

    @Override
    public void clear() {
        this.values = new Hashlet();
        this.invalidateOrder();
    }

    @Override
    public Iterator<Map.Entry<Field, FieldValue>> iterator() {
        return new FieldSet().iterator();
    }

    public Set<Map.Entry<Field, FieldValue>> getFields() {
        return new FieldSet();
    }

    @Override
    public void printXml(XmlStream xml) {
        if (this.getDataType().equals(PositionDataType.INSTANCE)) {
            try {
                PositionDataType.renderXml(this, xml);
                return;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        XmlSerializationHelper.printStructXml(this, xml);
    }

    @Override
    public FieldValue getFieldValue(Field field) {
        return (FieldValue)this.values.get((Object)field.getId());
    }

    @Override
    public Field getField(String fieldName) {
        return this.getDataType().getField(fieldName);
    }

    @Override
    public int getFieldCount() {
        return this.values.size();
    }

    @Override
    protected void doSetFieldValue(Field field, FieldValue value) {
        if (field == null) {
            throw new IllegalArgumentException("Invalid null field pointer");
        }
        Field myField = this.getDataType().getField(field.getId());
        if (myField == null) {
            throw new IllegalArgumentException("No such field in " + this.getDataType() + " : " + field.getName());
        }
        if (!myField.getDataType().isValueCompatible(value)) {
            throw new IllegalArgumentException("Incompatible data types. Got " + value.getDataType() + ", expected " + myField.getDataType());
        }
        if (myField.getId() != field.getId()) {
            throw new IllegalArgumentException("Inconsistent field: " + field);
        }
        int index = this.values.getIndexOfKey((Object)field.getId());
        if (index == -1) {
            this.values.put((Object)field.getId(), (Object)value);
            this.invalidateOrder();
        } else {
            this.values.setValue(index, (Object)value);
        }
    }

    @Override
    public FieldValue removeFieldValue(Field field) {
        FieldValue found = (FieldValue)this.values.get((Object)field.getId());
        if (found != null) {
            Hashlet copy = new Hashlet();
            copy.reserve(this.values.size() - 1);
            for (int i = 0; i < this.values.size(); ++i) {
                if (((Integer)this.values.key(i)).intValue() == field.getId()) continue;
                copy.put(this.values.key(i), this.values.value(i));
            }
            this.values = copy;
            this.invalidateOrder();
        }
        return found;
    }

    @Override
    public void assign(Object o) {
        if (o instanceof Struct && ((Struct)o).getDataType().equals(this.getDataType())) {
            this.clear();
            Iterator<Map.Entry<Field, FieldValue>> otherValues = ((Struct)o).iterator();
            while (otherValues.hasNext()) {
                Map.Entry<Field, FieldValue> otherEntry = otherValues.next();
                this.setFieldValue(otherEntry.getKey(), otherEntry.getValue());
            }
        } else {
            throw new IllegalArgumentException("Type " + o.getClass() + " can not specify a " + this.getClass() + " instance");
        }
    }

    public void assignFrom(StructuredFieldValue sfv) {
        this.clear();
        Iterator<Map.Entry<Field, FieldValue>> otherValues = sfv.iterator();
        while (otherValues.hasNext()) {
            Map.Entry<Field, FieldValue> otherEntry = otherValues.next();
            this.setFieldValue(otherEntry.getKey(), otherEntry.getValue());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Struct)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Struct struct = (Struct)o;
        return this.values.equals(struct.values);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append("Struct (").append(this.getDataType()).append("): ");
        int[] increasing = this.getInOrder();
        for (int i = 0; i < increasing.length; ++i) {
            int id = increasing[i];
            retVal.append(this.getDataType().getField(id)).append("=").append(this.values.get((Object)id)).append(", ");
        }
        return retVal.toString();
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue obj) {
        int cmp = super.compareTo(obj);
        if (cmp != 0) {
            return cmp;
        }
        Struct rhs = (Struct)obj;
        cmp = this.values.size() - rhs.values.size();
        if (cmp != 0) {
            return cmp;
        }
        StructDataType type = this.getDataType();
        for (Field field : type.getFields()) {
            FieldValue lhsField = this.getFieldValue(field);
            FieldValue rhsField = rhs.getFieldValue(field);
            if (lhsField != null && rhsField != null) {
                cmp = lhsField.compareTo(rhsField);
                if (cmp == 0) continue;
                return cmp;
            }
            if (lhsField == null && rhsField == null) continue;
            return lhsField != null ? -1 : 1;
        }
        return 0;
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    public static <T> T getFieldValue(FieldValue struct, DataType structType, String fieldName, Class<T> fieldType) {
        if (!(struct instanceof Struct)) {
            return null;
        }
        if (!struct.getDataType().equals(structType)) {
            return null;
        }
        FieldValue fieldValue = ((Struct)struct).getFieldValue(fieldName);
        if (!fieldType.isInstance(fieldValue)) {
            return null;
        }
        return fieldType.cast(fieldValue);
    }

    public static <T> T getFieldValue(FieldValue struct, DataType structType, Field field, Class<T> fieldType) {
        if (!(struct instanceof Struct)) {
            return null;
        }
        if (!struct.getDataType().equals(structType)) {
            return null;
        }
        FieldValue fieldValue = ((Struct)struct).getFieldValue(field);
        if (!fieldType.isInstance(fieldValue)) {
            return null;
        }
        return fieldType.cast(fieldValue);
    }

    static /* synthetic */ int[] access$400(Struct x0) {
        return x0.getInOrder();
    }

    private class FieldSetIterator
    implements Iterator<Map.Entry<Field, FieldValue>> {
        private int position = 0;
        private int[] increasing = Struct.access$400(Struct.this);

        private FieldSetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < this.increasing.length;
        }

        @Override
        public Map.Entry<Field, FieldValue> next() {
            if (this.position >= this.increasing.length) {
                throw new NoSuchElementException("No more elements in collection");
            }
            FieldEntry retval = new FieldEntry(this.increasing[this.position]);
            ++this.position;
            return retval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The set of fields and values of this struct is unmodifiable when accessed through this method.");
        }
    }

    private class FieldSet
    extends AbstractSet<Map.Entry<Field, FieldValue>> {
        private FieldSet() {
        }

        @Override
        public int size() {
            return Struct.this.values.size();
        }

        @Override
        public Iterator<Map.Entry<Field, FieldValue>> iterator() {
            return new FieldSetIterator();
        }
    }

    private class FieldEntry
    implements Map.Entry<Field, FieldValue> {
        private int id;

        private FieldEntry(int id) {
            this.id = id;
        }

        @Override
        public Field getKey() {
            return Struct.this.getDataType().getField(this.id);
        }

        @Override
        public FieldValue getValue() {
            return (FieldValue)Struct.this.values.get((Object)this.id);
        }

        @Override
        public FieldValue setValue(FieldValue value) {
            if (value == null) {
                throw new NullPointerException("Null values in Struct not supported, use removeFieldValue() to remove value instead.");
            }
            int index = Struct.this.values.getIndexOfKey((Object)this.id);
            FieldValue retVal = null;
            if (index == -1) {
                Struct.this.values.put((Object)this.id, (Object)value);
                Struct.this.invalidateOrder();
            } else {
                retVal = (FieldValue)Struct.this.values.value(index);
                Struct.this.values.setValue(index, (Object)value);
            }
            return retVal;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldEntry)) {
                return false;
            }
            FieldEntry that = (FieldEntry)o;
            return this.id == that.id;
        }

        @Override
        public int hashCode() {
            return this.id;
        }
    }
}

