/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select.rule;

import com.yahoo.document.BucketId;
import com.yahoo.document.BucketIdFactory;
import com.yahoo.document.DocumentId;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.idstring.GroupDocIdString;
import com.yahoo.document.select.BucketSet;
import com.yahoo.document.select.Context;
import com.yahoo.document.select.OrderingSpecification;
import com.yahoo.document.select.Result;
import com.yahoo.document.select.ResultList;
import com.yahoo.document.select.Visitor;
import com.yahoo.document.select.rule.AttributeNode;
import com.yahoo.document.select.rule.ExpressionNode;
import com.yahoo.document.select.rule.IdNode;
import com.yahoo.document.select.rule.LiteralNode;
import com.yahoo.document.select.rule.SearchColumnNode;
import java.util.regex.Pattern;

public class ComparisonNode
implements ExpressionNode {
    private ExpressionNode lhs;
    private ExpressionNode rhs;
    private String operator;

    public ComparisonNode(ExpressionNode lhs, String operator, ExpressionNode rhs) {
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    public ExpressionNode getLHS() {
        return this.lhs;
    }

    public ComparisonNode setLHS(ExpressionNode lhs) {
        this.lhs = lhs;
        return this;
    }

    public String getOperator() {
        return this.operator;
    }

    public ComparisonNode setOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public ExpressionNode getRHS() {
        return this.rhs;
    }

    public ComparisonNode setRHS(ExpressionNode rhs) {
        this.rhs = rhs;
        return this;
    }

    public OrderingSpecification getOrdering(IdNode lhs, LiteralNode rhs, String operator, int order) {
        if (lhs.getWidthBits() == -1 || lhs.getDivisionBits() == -1 || !(rhs.getValue() instanceof Long)) {
            return null;
        }
        if (operator.equals("==") || operator.equals("=")) {
            return new OrderingSpecification(order, (Long)rhs.getValue(), lhs.getWidthBits(), lhs.getDivisionBits());
        }
        if (order == OrderingSpecification.ASCENDING) {
            if (operator.equals("<") || operator.equals("<=")) {
                return new OrderingSpecification(order, 0L, lhs.getWidthBits(), lhs.getDivisionBits());
            }
            if (operator.equals(">")) {
                return new OrderingSpecification(order, (Long)rhs.getValue() + 1L, lhs.getWidthBits(), lhs.getDivisionBits());
            }
            if (operator.equals(">=")) {
                return new OrderingSpecification(order, (Long)rhs.getValue(), lhs.getWidthBits(), lhs.getDivisionBits());
            }
        } else {
            if (operator.equals("<")) {
                return new OrderingSpecification(order, (Long)rhs.getValue() - 1L, lhs.getWidthBits(), lhs.getDivisionBits());
            }
            if (operator.equals("<=")) {
                return new OrderingSpecification(order, (Long)rhs.getValue(), lhs.getWidthBits(), lhs.getDivisionBits());
            }
        }
        return null;
    }

    @Override
    public OrderingSpecification getOrdering(int order) {
        if (this.lhs instanceof IdNode && this.rhs instanceof LiteralNode) {
            return this.getOrdering((IdNode)this.lhs, (LiteralNode)this.rhs, this.operator, order);
        }
        if (this.rhs instanceof IdNode && this.lhs instanceof LiteralNode) {
            return this.getOrdering((IdNode)this.rhs, (LiteralNode)this.rhs, this.operator, order);
        }
        return null;
    }

    @Override
    public BucketSet getBucketSet(BucketIdFactory factory) {
        if (this.operator.equals("==") || this.operator.equals("=")) {
            if (this.lhs instanceof IdNode && this.rhs instanceof LiteralNode) {
                return this.compare(factory, (IdNode)this.lhs, (LiteralNode)this.rhs, this.operator);
            }
            if (this.rhs instanceof IdNode && this.lhs instanceof LiteralNode) {
                return this.compare(factory, (IdNode)this.rhs, (LiteralNode)this.lhs, this.operator);
            }
            if (this.lhs instanceof SearchColumnNode && this.rhs instanceof LiteralNode) {
                return this.compare(factory, (SearchColumnNode)this.lhs, (LiteralNode)this.rhs);
            }
            if (this.rhs instanceof SearchColumnNode && this.lhs instanceof LiteralNode) {
                return this.compare(factory, (SearchColumnNode)this.rhs, (LiteralNode)this.lhs);
            }
        }
        return null;
    }

    private BucketSet compare(BucketIdFactory factory, SearchColumnNode node, LiteralNode literal) {
        Object value = literal.getValue();
        int bucketCount = (int)Math.pow(2.0, 16.0);
        if (value instanceof Long) {
            BucketSet ret = new BucketSet();
            for (int i = 0; i < bucketCount; ++i) {
                BucketId id = new BucketId(16, i);
                if ((Long)value != (long)node.getDistribution().getColumn(id)) continue;
                ret.add(new BucketId(16, i));
            }
            return ret;
        }
        return null;
    }

    private BucketSet compare(BucketIdFactory factory, IdNode id, LiteralNode literal, String operator) {
        String field = id.getField();
        Object value = literal.getValue();
        if (field == null) {
            if (value instanceof String) {
                String name = (String)value;
                if (operator.equals("=") && name.contains("*") || operator.equals("=~") && (name.contains("*") || name.contains("?"))) {
                    return null;
                }
                return new BucketSet(factory.getBucketId(new DocumentId(name)));
            }
        } else if (field.equalsIgnoreCase("user")) {
            if (value instanceof Long) {
                return new BucketSet(new BucketId(factory.getLocationBitCount(), (Long)value));
            }
        } else if (field.equalsIgnoreCase("group")) {
            if (value instanceof String) {
                String name = (String)value;
                if (operator.equals("=") && name.contains("*") || operator.equals("=~") && (name.contains("*") || name.contains("?"))) {
                    return null;
                }
                return new BucketSet(new BucketId(factory.getLocationBitCount(), new GroupDocIdString("", name, "").getLocation()));
            }
        } else if (field.equalsIgnoreCase("bucket") && value instanceof Long) {
            return new BucketSet(new BucketId((Long)value));
        }
        return null;
    }

    @Override
    public Object evaluate(Context context) {
        Object oLeft = this.lhs.evaluate(context);
        Object oRight = this.rhs.evaluate(context);
        if (oLeft == null && oRight == null) {
            return new ResultList(Result.TRUE);
        }
        if (oLeft == Result.INVALID || oRight == Result.INVALID) {
            return new ResultList(Result.INVALID);
        }
        if (oLeft instanceof AttributeNode.VariableValueList && oRight instanceof AttributeNode.VariableValueList) {
            if (this.operator.equals("==")) {
                return this.evaluateListsTrue((AttributeNode.VariableValueList)oLeft, (AttributeNode.VariableValueList)oRight);
            }
            if (this.operator.equals("!=")) {
                return this.evaluateListsFalse((AttributeNode.VariableValueList)oLeft, (AttributeNode.VariableValueList)oRight);
            }
            return new ResultList(Result.INVALID);
        }
        if (oLeft instanceof AttributeNode.VariableValueList) {
            return this.evaluateListAndSingle((AttributeNode.VariableValueList)oLeft, oRight);
        }
        if (oRight instanceof AttributeNode.VariableValueList) {
            return this.evaluateListAndSingle((AttributeNode.VariableValueList)oRight, oLeft);
        }
        return new ResultList(this.evaluateBool(oLeft, oRight));
    }

    public ResultList evaluateListsTrue(AttributeNode.VariableValueList lhs, AttributeNode.VariableValueList rhs) {
        if (lhs.size() != rhs.size()) {
            return new ResultList(Result.FALSE);
        }
        for (int i = 0; i < lhs.size(); ++i) {
            if (!((ResultList.VariableValue)lhs.get(i)).getVariables().equals(((ResultList.VariableValue)rhs.get(i)).getVariables())) {
                return new ResultList(Result.FALSE);
            }
            if (this.evaluateEquals(((ResultList.VariableValue)lhs.get(i)).getValue(), ((ResultList.VariableValue)rhs.get(i)).getValue()) != Result.FALSE) continue;
            return new ResultList(Result.FALSE);
        }
        return new ResultList(Result.TRUE);
    }

    public ResultList evaluateListsFalse(AttributeNode.VariableValueList lhs, AttributeNode.VariableValueList rhs) {
        ResultList lst = this.evaluateListsTrue(lhs, rhs);
        if (lst.toResult() == Result.TRUE) {
            return new ResultList(Result.FALSE);
        }
        if (lst.toResult() == Result.FALSE) {
            return new ResultList(Result.TRUE);
        }
        return lst;
    }

    public ResultList evaluateListAndSingle(AttributeNode.VariableValueList lhs, Object rhs) {
        if (rhs == null && lhs == null) {
            return new ResultList(Result.TRUE);
        }
        if (rhs == null || lhs == null) {
            return new ResultList(Result.FALSE);
        }
        ResultList retVal = new ResultList();
        for (int i = 0; i < lhs.size(); ++i) {
            Result result = this.evaluateBool(((ResultList.VariableValue)lhs.get(i)).getValue(), rhs);
            retVal.add((FieldPathIteratorHandler.VariableMap)((ResultList.VariableValue)lhs.get(i)).getVariables().clone(), result);
        }
        return retVal;
    }

    private Result evaluateBool(Object lhs, Object rhs) {
        if (this.operator.equals("==")) {
            return this.evaluateEquals(lhs, rhs);
        }
        if (this.operator.equals("!=")) {
            return Result.invert(this.evaluateEquals(lhs, rhs));
        }
        if (this.operator.equals("<") || this.operator.equals("<=") || this.operator.equals(">") || this.operator.equals(">=")) {
            return this.evaluateNumber(lhs, rhs);
        }
        if (this.operator.equals("=~") || this.operator.equals("=")) {
            return this.evaluateString(lhs, rhs);
        }
        throw new IllegalStateException("Comparison operator '" + this.operator + "' is not supported.");
    }

    private Result evaluateEquals(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return Result.toResult(lhs == rhs);
        }
        double a = this.getAsNumber(lhs);
        double b = this.getAsNumber(rhs);
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Result.toResult(lhs.toString().equals(rhs.toString()));
        }
        return Result.toResult(a == b);
    }

    private double getAsNumber(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof NumericFieldValue) {
            return this.getAsNumber(((NumericFieldValue)value).getNumber());
        }
        return Double.NaN;
    }

    private Result evaluateNumber(Object lhs, Object rhs) {
        double a = this.getAsNumber(lhs);
        double b = this.getAsNumber(rhs);
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return Result.INVALID;
        }
        if (this.operator.equals("<")) {
            return Result.toResult(a < b);
        }
        if (this.operator.equals("<=")) {
            return Result.toResult(a <= b);
        }
        if (this.operator.equals(">")) {
            return Result.toResult(a > b);
        }
        return Result.toResult(a >= b);
    }

    private Result evaluateString(Object lhs, Object rhs) {
        String left = "" + lhs;
        String right = "" + rhs;
        if (this.operator.equals("=~")) {
            return Result.toResult(Pattern.compile(right).matcher(left).find());
        }
        return Result.toResult(Pattern.compile(this.globToRegex(right)).matcher(left).find());
    }

    private String globToRegex(String glob) {
        StringBuilder ret = new StringBuilder();
        ret.append("^");
        for (int i = 0; i < glob.length(); ++i) {
            ret.append(this.globToRegex(glob.charAt(i)));
        }
        ret.append("$");
        return ret.toString();
    }

    private String globToRegex(char glob) {
        switch (glob) {
            case '*': {
                return ".*";
            }
            case '?': {
                return ".";
            }
            case '$': 
            case '(': 
            case ')': 
            case '+': 
            case '.': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return "\\" + glob;
            }
        }
        return "" + glob;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.lhs + " " + this.operator + " " + this.rhs;
    }
}

