/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.idstring;

import com.yahoo.document.idstring.DocIdString;
import com.yahoo.document.idstring.GroupDocIdString;
import com.yahoo.document.idstring.IdIdString;
import com.yahoo.document.idstring.OrderDocIdString;
import com.yahoo.document.idstring.UserDocIdString;
import com.yahoo.text.Text;
import com.yahoo.text.Utf8String;
import java.math.BigInteger;
import java.util.OptionalInt;

public abstract class IdString {
    final Scheme scheme;
    final String namespace;
    final String namespaceSpecific;
    Utf8String cache;

    public boolean hasDocType() {
        return false;
    }

    public String getDocType() {
        return "";
    }

    public boolean hasGroup() {
        return false;
    }

    public boolean hasNumber() {
        return false;
    }

    public long getNumber() {
        return 0L;
    }

    public String getGroup() {
        return "";
    }

    public static int[] generateOrderDocParams(String scheme) {
        int parenPos = scheme.indexOf("(");
        int endParenPos = scheme.indexOf(")");
        if (parenPos == -1 || endParenPos == -1) {
            throw new IllegalArgumentException("Unparseable scheme " + scheme + ": Must be on the form orderdoc(width, division)");
        }
        String params = scheme.substring(parenPos + 1, endParenPos);
        String[] vals = params.split(",");
        if (vals.length != 2) {
            throw new IllegalArgumentException("Unparseable scheme " + scheme + ": Must be on the form orderdoc(width, division)");
        }
        int[] retVal = new int[2];
        try {
            retVal[0] = Integer.parseInt(vals[0]);
            retVal[1] = Integer.parseInt(vals[1]);
            return retVal;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unparseable scheme " + scheme + ": Must be on the form orderdoc(width, division)");
        }
    }

    public static IdString createIdString(String id) {
        IdString.validateTextString(id);
        return IdString.parseAndCreate(id);
    }

    public static IdString createFromSerialized(String id) {
        IdString.validateNoZeroBytes(id);
        return IdString.parseAndCreate(id);
    }

    private static void validateTextString(String id) {
        OptionalInt illegalCodePoint = Text.validateTextString((String)id);
        if (illegalCodePoint.isPresent()) {
            throw new IllegalArgumentException("Unparseable id '" + id + "': Contains illegal code point 0x" + Integer.toHexString(illegalCodePoint.getAsInt()).toUpperCase());
        }
    }

    private static void validateNoZeroBytes(String id) {
        for (int i = 0; i < id.length(); ++i) {
            if (id.codePointAt(i) != 0) continue;
            throw new IllegalArgumentException("Unparseable id '" + id + "': Contains illegal zero byte code point");
        }
    }

    private static IdString parseAndCreate(String id) {
        int schemePos = id.indexOf(":");
        if (schemePos < 0) {
            throw new IllegalArgumentException("Unparseable id '" + id + "': Scheme missing");
        }
        String schemeStr = id.substring(0, schemePos);
        int currPos = schemePos + 1;
        int colonPos = id.indexOf(":", currPos);
        if (colonPos < 0) {
            throw new IllegalArgumentException("Unparseable id '" + id + "': Namespace missing");
        }
        String namespace = id.substring(currPos, colonPos);
        if (namespace.length() == 0) {
            throw new IllegalArgumentException("Unparseable id '" + id + "': Namespace must be non-empty");
        }
        currPos = colonPos + 1;
        if (schemeStr.equals("id")) {
            colonPos = id.indexOf(":", currPos);
            if (colonPos < 0) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': Document type missing");
            }
            String type = id.substring(currPos, colonPos);
            currPos = colonPos + 1;
            if ((colonPos = id.indexOf(":", currPos)) < 0) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': Key/value section missing");
            }
            String keyValues = id.substring(currPos, colonPos);
            currPos = colonPos + 1;
            return new IdIdString(namespace, type, keyValues, id.substring(currPos));
        }
        if (schemeStr.equals("doc")) {
            return new DocIdString(namespace, id.substring(currPos));
        }
        if (schemeStr.equals("userdoc")) {
            long userId;
            colonPos = id.indexOf(":", currPos);
            if (colonPos < 0) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': User id missing");
            }
            try {
                userId = new BigInteger(id.substring(currPos, colonPos)).longValue();
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': " + iae.getMessage(), iae.getCause());
            }
            currPos = colonPos + 1;
            return new UserDocIdString(namespace, userId, id.substring(currPos));
        }
        if (schemeStr.equals("groupdoc")) {
            colonPos = id.indexOf(":", currPos);
            if (colonPos < 0) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': Group id missing");
            }
            String group = id.substring(currPos, colonPos);
            currPos = colonPos + 1;
            return new GroupDocIdString(namespace, group, id.substring(currPos));
        }
        if (schemeStr.indexOf("orderdoc") == 0) {
            long ordering;
            int[] params = IdString.generateOrderDocParams(schemeStr);
            colonPos = id.indexOf(":", currPos);
            if (colonPos < 0) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': Group id missing");
            }
            String group = id.substring(currPos, colonPos);
            currPos = colonPos + 1;
            if ((colonPos = id.indexOf(":", currPos)) < 0) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': Ordering missing");
            }
            try {
                ordering = Long.parseLong(id.substring(currPos, colonPos));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': " + e.getMessage(), e.getCause());
            }
            currPos = colonPos + 1;
            return new OrderDocIdString(namespace, group, params[0], params[1], ordering, id.substring(currPos));
        }
        throw new IllegalArgumentException("Unknown id scheme '" + schemeStr + "'");
    }

    protected IdString(Scheme scheme, String namespace, String namespaceSpecific) {
        this.scheme = scheme;
        this.namespace = namespace;
        this.namespaceSpecific = namespaceSpecific;
    }

    public Scheme getType() {
        return this.scheme;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceSpecific() {
        return this.namespaceSpecific;
    }

    public abstract long getLocation();

    public String getSchemeParameters() {
        return "";
    }

    public abstract String getSchemeSpecific();

    public GidModifier getGidModifier() {
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof IdString && o.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private Utf8String createToString() {
        return new Utf8String(this.scheme.toString() + this.getSchemeParameters() + ':' + this.namespace + ':' + this.getSchemeSpecific() + this.namespaceSpecific);
    }

    public String toString() {
        if (this.cache == null) {
            this.cache = this.createToString();
        }
        return this.cache.toString();
    }

    public Utf8String toUtf8() {
        if (this.cache == null) {
            this.cache = this.createToString();
        }
        return this.cache;
    }

    public static enum Scheme {
        doc,
        userdoc,
        groupdoc,
        orderdoc,
        id;

    }

    public class GidModifier {
        public int usedBits;
        public long value;
    }
}

