/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.async;

import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncCallback;
import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperation;
import com.yahoo.vespa.clustercontroller.utils.communication.async.AsyncOperationListenImpl;
import java.util.logging.Logger;

public class AsyncOperationImpl<T>
implements AsyncOperation<T> {
    private static final Logger log = Logger.getLogger(AsyncOperationImpl.class.getName());
    private final String name;
    private final String description;
    private boolean resultGotten = false;
    private boolean completed = false;
    private boolean failed = false;
    private T result;
    private Exception failure;
    private final AsyncOperationListenImpl<T> listenImpl;

    public AsyncOperationImpl(String name) {
        this(name, null);
    }

    public AsyncOperationImpl(String name, String description) {
        this.name = name;
        this.description = description;
        this.listenImpl = new AsyncOperationListenImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tagResultHandled() {
        AsyncOperationListenImpl<T> asyncOperationListenImpl = this.listenImpl;
        synchronized (asyncOperationListenImpl) {
            if (this.resultGotten) {
                log.fine("Operation " + this + " got result attempted set twice. This may occasionally happen if multiple sources are set to possibly terminate operations, such as for example if there is a separate cancel or timeout handler.");
                return false;
            }
            this.resultGotten = true;
            return true;
        }
    }

    public void setFailure(Exception e) {
        this.setFailure(e, null);
    }

    public void setFailure(Exception e, T partialResult) {
        if (!this.tagResultHandled()) {
            return;
        }
        this.failed = true;
        this.failure = e;
        this.result = partialResult;
        this.completed = true;
        this.listenImpl.notifyListeners();
    }

    public void setResult(T result) {
        if (!this.tagResultHandled()) {
            return;
        }
        this.result = result;
        this.completed = true;
        this.listenImpl.notifyListeners();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "AsyncOperationImpl(" + this.name + ")";
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public boolean cancel() {
        return false;
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    @Override
    public boolean isSuccess() {
        return this.completed && !this.failed;
    }

    @Override
    public Double getProgress() {
        return this.completed ? Double.valueOf(1.0) : null;
    }

    @Override
    public Exception getCause() {
        return this.failure;
    }

    @Override
    public void register(AsyncCallback<T> callback) {
        this.listenImpl.register(callback);
    }

    @Override
    public void unregister(AsyncCallback<T> callback) {
        this.listenImpl.unregister(callback);
    }
}

