/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.util;

import com.yahoo.vespa.clustercontroller.utils.util.MetricReporter;
import java.util.Map;
import java.util.TreeMap;

public class ComponentMetricReporter
implements MetricReporter {
    private final MetricReporter impl;
    private final String prefix;
    private final Map<String, String> defaultDimensions = new TreeMap<String, String>();
    private MetricReporter.Context defaultContext;

    public ComponentMetricReporter(MetricReporter impl, String prefix) {
        this.impl = impl;
        this.prefix = prefix;
        this.defaultContext = impl.createContext(this.defaultDimensions);
    }

    public ComponentMetricReporter addDimension(String key, String value) {
        this.defaultDimensions.put(key, value);
        this.defaultContext = this.impl.createContext(this.defaultDimensions);
        return this;
    }

    public void set(String name, Number value) {
        this.impl.set(this.prefix + name, value, this.defaultContext);
    }

    public void add(String name, Number value) {
        this.impl.add(this.prefix + name, value, this.defaultContext);
    }

    @Override
    public void set(String name, Number value, MetricReporter.Context context) {
        this.impl.set(this.prefix + name, value, context);
    }

    @Override
    public void add(String name, Number value, MetricReporter.Context context) {
        this.impl.add(this.prefix + name, value, context);
    }

    @Override
    public MetricReporter.Context createContext(Map<String, ?> stringMap) {
        if (stringMap == null) {
            return this.defaultContext;
        }
        TreeMap m = new TreeMap(stringMap);
        for (String key : this.defaultDimensions.keySet()) {
            if (m.containsKey(key)) continue;
            m.put(key, this.defaultDimensions.get(key));
        }
        return this.impl.createContext(m);
    }
}

