/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.shade.DefaultShader;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.plugins.shade.mojo.ArchiveFilter;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

@Mojo(name="assemble-fat-jar", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class AssembleFatJarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}")
    public MavenSession session;
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    @Component
    public DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(defaultValue="${project.artifactId}-jar-with-dependencies")
    public String finalName;
    @Parameter(defaultValue="com.yahoo.vespa:vespa-3party-jars")
    public String projectDefiningInstalledDependencies;
    @Parameter(defaultValue="${project.build.directory}")
    public File outputDirectory;
    @Parameter
    public String mainClass;
    @Parameter
    public String[] excludes = new String[0];
    private final Set<String> defaultExcludes = Set.of("META-INF/DEPENDENCIES", "META-INF/LICENSE*", "META-INF/NOTICE*", "META-INF/MANIFEST.MF", "META-INF/*.SF", "META-INF/*.DSA", "META-INF/*.RSA", "about.html", "module-info.class", "license/*", "**/package-info.class", "**/module-info.class");

    public void execute() throws MojoExecutionException {
        SortedSet<Artifact> installedDependencies = this.resolveThirdPartyArtifactsInstalledInVespaHomeLibJars();
        TreeSet<Artifact> projectDependencies = new TreeSet<Artifact>(this.project.getArtifacts());
        File outputFile = this.outputFile();
        ArchiveFilter archiveFilter = new ArchiveFilter(){

            public String getArtifact() {
                return null;
            }

            public Set<String> getIncludes() {
                return Set.of();
            }

            public Set<String> getExcludes() {
                TreeSet<String> values = new TreeSet<String>(AssembleFatJarMojo.this.defaultExcludes);
                values.addAll(List.of(AssembleFatJarMojo.this.excludes));
                return values;
            }

            public boolean getExcludeDefaults() {
                return true;
            }
        };
        LinkedHashSet jarsToShade = projectDependencies.stream().filter(d -> !installedDependencies.contains(d) && !d.getType().equals("pom") && d.getScope().equals("compile")).map(Artifact::getFile).collect(Collectors.toCollection(LinkedHashSet::new));
        jarsToShade.add(this.project.getArtifact().getFile());
        try {
            String classpath = this.generateClasspath(installedDependencies, projectDependencies);
            ShadeRequest req = new ShadeRequest();
            req.setJars((Set)jarsToShade);
            req.setUberJar(outputFile);
            req.setFilters(List.of(new SimpleFilter((Set)jarsToShade, archiveFilter)));
            req.setRelocators(List.of());
            req.setResourceTransformers(List.of(new ManifestWriter(classpath, this.mainClass)));
            req.setShadeSourcesContent(false);
            new DefaultShader().shade(req);
            Files.copy(outputFile.toPath(), this.finalFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private String generateClasspath(Set<Artifact> installedDependencies, SortedSet<Artifact> projectDependencies) {
        return projectDependencies.stream().filter(installedDependencies::contains).map(AssembleFatJarMojo::filename).collect(Collectors.joining(" "));
    }

    private static String filename(Artifact a) {
        return a.getGroupId().equals("com.yahoo.vespa") ? "%s-jar-with-dependencies.jar".formatted(a.getArtifactId()) : a.getFile().getName();
    }

    private File outputFile() {
        Artifact a = this.project.getArtifact();
        String name = this.project.getArtifactId() + "-" + a.getVersion() + "-shaded." + a.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, name);
    }

    private File finalFile() {
        String name = this.finalName + "." + this.project.getArtifact().getArtifactHandler().getExtension();
        return new File(this.outputDirectory, name);
    }

    private SortedSet<Artifact> resolveThirdPartyArtifactsInstalledInVespaHomeLibJars() throws MojoExecutionException {
        try {
            String[] installedDepsProject = this.projectDefiningInstalledDependencies.split(":");
            MavenProject project = this.session.getAllProjects().stream().filter(p -> p.getGroupId().equals(installedDepsProject[0]) && p.getArtifactId().equals(installedDepsProject[1])).findAny().orElseThrow(() -> new IllegalStateException("Cannot find %s. Build from project root with 'mvn install -pl :%s'".formatted(this.projectDefiningInstalledDependencies, this.project.getArtifactId())));
            DefaultProjectBuildingRequest req = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            req.setProject(project);
            DependencyNode root = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)req, null);
            return AssembleFatJarMojo.getAllRecursive(root);
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private static SortedSet<Artifact> getAllRecursive(DependencyNode node) {
        TreeSet<Artifact> children = new TreeSet<Artifact>();
        if (node.getChildren() != null) {
            for (DependencyNode dep : node.getChildren()) {
                Artifact a = dep.getArtifact();
                if (!a.getType().equals("pom")) {
                    children.add(a);
                }
                children.addAll(AssembleFatJarMojo.getAllRecursive(dep));
            }
        }
        return children;
    }

    private static class ManifestWriter
    implements ResourceTransformer {
        private final String classpath;
        private final String mainclass;

        ManifestWriter(String classpath, String mainclass) {
            this.classpath = classpath;
            this.mainclass = mainclass;
        }

        public boolean canTransformResource(String resource) {
            return false;
        }

        public void processResource(String resource, InputStream is, List<Relocator> relocators) {
        }

        public boolean hasTransformedResource() {
            return true;
        }

        public void modifyOutputStream(JarOutputStream os) throws IOException {
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attributes.putValue("Class-Path", this.classpath);
            attributes.putValue("Created-By", "vespa container maven plugin");
            if (this.mainclass != null) {
                attributes.putValue("Main-Class", this.mainclass);
            }
            JarEntry entry = new JarEntry("META-INF/MANIFEST.MF");
            entry.setTime(System.currentTimeMillis());
            os.putNextEntry(entry);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            os.write(baos.toByteArray());
            os.flush();
        }
    }
}

