/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.osgi;

import com.google.common.collect.Sets;
import com.yahoo.container.plugin.osgi.ExportPackages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ImportPackages {
    public static final int INFINITE_VERSION = 99999;
    private static final String GUAVA_BASE_PACKAGE = "com.google.common";

    public static Map<String, Import> calculateImports(Set<String> referencedPackages, Set<String> implementedPackages, Map<String, ExportPackages.Export> exportedPackages) {
        HashMap<String, Import> ret = new HashMap<String, Import>();
        for (String undefinedPackage : Sets.difference(referencedPackages, implementedPackages)) {
            ExportPackages.Export export = exportedPackages.get(undefinedPackage);
            if (export == null) continue;
            ret.put(undefinedPackage, new Import(undefinedPackage, ImportPackages.version(export)));
        }
        return ret;
    }

    private static Optional<String> version(ExportPackages.Export export) {
        for (ExportPackages.Parameter param : export.getParameters()) {
            if (!"version".equals(param.getName())) continue;
            return Optional.of(param.getValue());
        }
        return Optional.empty();
    }

    public static class Import {
        private final String packageName;
        private final List<Integer> versionNumber;

        public Import(String packageName, Optional<String> version) {
            this.packageName = packageName;
            this.versionNumber = new ArrayList<Integer>();
            if (version.isPresent()) {
                try {
                    Arrays.stream(version.get().split("\\.")).map(Integer::parseInt).limit(3L).forEach(this.versionNumber::add);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid version number '%s' for package '%s'.", version.get(), packageName), e);
                }
            }
        }

        public Optional<Integer> majorVersion() {
            if (this.versionNumber.size() >= 1) {
                return Optional.of(this.versionNumber.get(0));
            }
            return Optional.empty();
        }

        public String packageName() {
            return this.packageName;
        }

        public String version() {
            return this.versionNumber.stream().map(Object::toString).collect(Collectors.joining("."));
        }

        public Optional<String> importVersionRange() {
            if (this.versionNumber.isEmpty()) {
                return Optional.empty();
            }
            int upperLimit = this.isGuavaPackage() ? 99999 : this.versionNumber.get(0) + 1;
            return Optional.of(String.format("[%s,%d)", this.version(), upperLimit));
        }

        public boolean isGuavaPackage() {
            return this.packageName.equals(ImportPackages.GUAVA_BASE_PACKAGE) || this.packageName.startsWith("com.google.common.");
        }

        public String asOsgiImport() {
            return this.packageName + this.importVersionRange().map(version -> ";version=\"" + version + "\"").orElse("");
        }
    }
}

