/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.shade.DefaultShader;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-provided-artifact-manifest", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateProvidedArtifactManifestMojo
extends AbstractMojo {
    public static final String PROVIDED_ARTIFACTS_MANIFEST_ENTRY = "X-JDisc-Provided-Artifact";
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    public File outputDirectory;

    public void execute() throws MojoExecutionException {
        File originalJar = this.project.getArtifact().getFile();
        File shadedJar = this.shadedJarFile();
        ShadeRequest req = new ShadeRequest();
        req.setJars(Set.of(originalJar));
        req.setUberJar(shadedJar);
        req.setResourceTransformers(List.of(new ProvidedArtifactsManifestUpdater()));
        req.setRelocators(List.of());
        req.setFilters(List.of());
        try {
            new DefaultShader().shade(req);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        try {
            this.getLog().info((CharSequence)"Replacing original jar with transformed jar");
            FileUtils.copyFile((File)shadedJar, (File)originalJar);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private File shadedJarFile() {
        Artifact a = this.project.getArtifact();
        String name = this.project.getArtifactId() + "-shaded." + a.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, name);
    }

    private static class ProvidedArtifactsManifestUpdater
    implements ResourceTransformer {
        private Manifest manifest;

        private ProvidedArtifactsManifestUpdater() {
        }

        public boolean canTransformResource(String resource) {
            return "META-INF/MANIFEST.MF".equalsIgnoreCase(resource);
        }

        public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
            this.manifest = new Manifest(is);
            Attributes attributes = this.manifest.getMainAttributes();
            String providedArtifacts = attributes.getValue("Class-Path");
            if (providedArtifacts == null) {
                return;
            }
            attributes.remove(new Attributes.Name("Class-Path"));
            attributes.putValue(GenerateProvidedArtifactManifestMojo.PROVIDED_ARTIFACTS_MANIFEST_ENTRY, providedArtifacts.replace(" ", ","));
            attributes.putValue("Created-By", "vespa container maven plugin");
        }

        public boolean hasTransformedResource() {
            return true;
        }

        public void modifyOutputStream(JarOutputStream os) throws IOException {
            if (this.manifest == null) {
                return;
            }
            JarEntry jarEntry = new JarEntry("META-INF/MANIFEST.MF");
            os.putNextEntry(jarEntry);
            this.manifest.write(os);
        }
    }
}

