/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.bundle;

import com.yahoo.container.plugin.osgi.ExportPackageParser;
import com.yahoo.container.plugin.osgi.ExportPackages;
import com.yahoo.container.plugin.util.JarFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.jar.Manifest;

public class AnalyzeBundle {
    public static List<ExportPackages.Export> exportedPackagesAggregated(Collection<File> jarFiles) {
        ArrayList<ExportPackages.Export> exports = new ArrayList<ExportPackages.Export>();
        for (File jarFile : jarFiles) {
            List<ExportPackages.Export> exported = AnalyzeBundle.exportedPackages(jarFile);
            exports.addAll(exported);
        }
        return exports;
    }

    static List<ExportPackages.Export> exportedPackages(File jarFile) {
        Manifest manifest = AnalyzeBundle.getOsgiManifest(jarFile);
        if (manifest == null) {
            return Collections.emptyList();
        }
        try {
            return AnalyzeBundle.parseExports(manifest);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Invalid manifest in bundle '%s'", jarFile.getPath()), e);
        }
    }

    public static List<String> nonPublicApiPackagesAggregated(Collection<File> jarFiles) {
        return jarFiles.stream().map(AnalyzeBundle::nonPublicApiPackages).flatMap(Collection::stream).distinct().toList();
    }

    private static List<String> nonPublicApiPackages(File jarFile) {
        Manifest manifest = AnalyzeBundle.getOsgiManifest(jarFile);
        if (manifest == null) {
            return Collections.emptyList();
        }
        return JarFiles.getMainAttributeValue(manifest, "X-JDisc-Non-PublicApi-Export-Package").map(s -> Arrays.asList(s.split(","))).orElseGet(ArrayList::new);
    }

    private static Manifest getOsgiManifest(File jarFile) {
        Manifest manifest;
        Optional<Manifest> jarManifest = JarFiles.getManifest(jarFile);
        if (jarManifest.isPresent() && AnalyzeBundle.isOsgiManifest(manifest = jarManifest.get())) {
            return manifest;
        }
        return null;
    }

    public static Optional<String> bundleSymbolicName(File jarFile) {
        return JarFiles.getManifest(jarFile).flatMap(AnalyzeBundle::getBundleSymbolicName);
    }

    private static List<ExportPackages.Export> parseExports(Manifest jarManifest) {
        return JarFiles.getMainAttributeValue(jarManifest, "Export-Package").map(ExportPackageParser::parseExports).orElseGet(ArrayList::new);
    }

    private static boolean isOsgiManifest(Manifest mf) {
        return AnalyzeBundle.getBundleSymbolicName(mf).isPresent();
    }

    private static Optional<String> getBundleSymbolicName(Manifest mf) {
        return JarFiles.getMainAttributeValue(mf, "Bundle-SymbolicName");
    }
}

