/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.google.common.collect.Sets;
import com.yahoo.container.plugin.bundle.AnalyzeBundle;
import com.yahoo.container.plugin.classanalysis.Analyze;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.PackageTally;
import com.yahoo.container.plugin.mojo.AbstractGenerateOsgiManifestMojo;
import com.yahoo.container.plugin.mojo.Artifacts;
import com.yahoo.container.plugin.osgi.ExportPackages;
import com.yahoo.container.plugin.osgi.ImportPackages;
import com.yahoo.container.plugin.util.Files;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-osgi-manifest", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class GenerateOsgiManifestMojo
extends AbstractGenerateOsgiManifestMojo {
    @Parameter
    private String discApplicationClass = null;
    @Parameter
    private String discPreInstallBundle = null;
    @Parameter(alias="Bundle-Activator")
    private String bundleActivator = null;
    @Parameter(alias="X-JDisc-Privileged-Activator")
    private String jdiscPrivilegedActivator = null;
    @Parameter(alias="WebInfUrl")
    private String webInfUrl = null;
    @Parameter(alias="Main-Class")
    private String mainClass = null;
    @Parameter(defaultValue="false")
    private boolean buildVespaPlatformBundle;

    public void execute() throws MojoExecutionException {
        try {
            if (this.discPreInstallBundle != null && !this.buildVespaPlatformBundle) {
                throw new MojoExecutionException("The 'discPreInstallBundle' parameter can only be used by Vespa platform bundles.");
            }
            Artifacts.ArtifactSet artifactSet = Artifacts.getArtifacts(this.project);
            this.warnOnUnsupportedArtifacts(artifactSet.getNonJarArtifacts());
            this.warnIfInternalContainerArtifactsAreIncluded(artifactSet.getJarArtifactsToInclude());
            List<ExportPackages.Export> exportedPackagesFromProvidedJars = AnalyzeBundle.exportedPackagesAggregated(artifactSet.getJarArtifactsProvided().stream().map(Artifact::getFile).collect(Collectors.toList()));
            Set<String> exportedPackagesFromProvidedDeps = ExportPackages.packageNames(exportedPackagesFromProvidedJars);
            PackageTally projectPackages = this.getProjectClassesTally();
            PackageTally compileJarsPackages = this.definedPackages(artifactSet.getJarArtifactsToInclude());
            PackageTally includedPackages = projectPackages.combine(compileJarsPackages);
            this.logDebugPackageSets(exportedPackagesFromProvidedJars, includedPackages);
            if (this.hasJdiscCoreProvided(artifactSet.getJarArtifactsProvided())) {
                this.logMissingPackages(exportedPackagesFromProvidedDeps, projectPackages, compileJarsPackages, includedPackages);
            } else {
                this.getLog().warn((CharSequence)"This project does not have jdisc_core as provided dependency, so the generated 'Import-Package' OSGi header may be missing important packages.");
            }
            this.logOverlappingPackages(projectPackages, exportedPackagesFromProvidedDeps);
            this.logUnnecessaryPackages(compileJarsPackages, exportedPackagesFromProvidedDeps);
            Map<String, ImportPackages.Import> calculatedImports = ImportPackages.calculateImports(includedPackages.referencedPackages(), includedPackages.definedPackages(), ExportPackages.exportsByPackageName(exportedPackagesFromProvidedJars));
            Map<String, String> manifestContent = this.generateManifestContent(artifactSet.getJarArtifactsToInclude(), calculatedImports, includedPackages);
            this.addAdditionalManifestProperties(manifestContent);
            GenerateOsgiManifestMojo.createManifestFile(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]), manifestContent);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed generating osgi manifest", e);
        }
    }

    private void addAdditionalManifestProperties(Map<String, String> manifestContent) {
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "Bundle-Activator", this.bundleActivator);
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-Privileged-Activator", this.jdiscPrivilegedActivator);
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "Main-Class", this.mainClass);
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-Application", this.discApplicationClass);
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-Preinstall-Bundle", GenerateOsgiManifestMojo.trimWhitespace(Optional.ofNullable(this.discPreInstallBundle)));
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "WebInfUrl", this.webInfUrl);
    }

    private void logDebugPackageSets(List<ExportPackages.Export> exportedPackagesFromProvidedJars, PackageTally includedPackages) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Referenced packages = " + includedPackages.referencedPackages()));
            this.getLog().debug((CharSequence)("Defined packages = " + includedPackages.definedPackages()));
            this.getLog().debug((CharSequence)("Exported packages of dependencies = " + exportedPackagesFromProvidedJars.stream().map(e -> "(" + e.getPackageNames().toString() + ", " + e.version().orElse("")).collect(Collectors.joining(", "))));
        }
    }

    private boolean hasJdiscCoreProvided(List<Artifact> providedArtifacts) {
        return providedArtifacts.stream().anyMatch(artifact -> artifact.getArtifactId().equals("jdisc_core"));
    }

    private void logMissingPackages(Set<String> exportedPackagesFromProvidedJars, PackageTally projectPackages, PackageTally compileJarPackages, PackageTally includedPackages) {
        Set<String> missingCompilePackages;
        Sets.SetView definedAndExportedPackages = Sets.union(includedPackages.definedPackages(), exportedPackagesFromProvidedJars);
        Set<String> missingProjectPackages = projectPackages.referencedPackagesMissingFrom((Set<String>)definedAndExportedPackages);
        if (!missingProjectPackages.isEmpty()) {
            this.getLog().warn((CharSequence)("Packages unavailable runtime are referenced from project classes (annotations can usually be ignored): " + missingProjectPackages));
        }
        if (!(missingCompilePackages = compileJarPackages.referencedPackagesMissingFrom((Set<String>)definedAndExportedPackages)).isEmpty()) {
            this.getLog().info((CharSequence)("Packages unavailable runtime are referenced from compile scoped jars (annotations can usually be ignored): " + missingCompilePackages));
        }
    }

    private void logOverlappingPackages(PackageTally projectPackages, Set<String> exportedPackagesFromProvidedDeps) {
        Sets.SetView overlappingProjectPackages = Sets.intersection(projectPackages.definedPackages(), exportedPackagesFromProvidedDeps);
        if (!overlappingProjectPackages.isEmpty()) {
            this.getLog().warn((CharSequence)("This project defines packages that are also defined in provided scoped dependencies (overlapping packages are strongly discouraged): " + (Set)overlappingProjectPackages));
        }
    }

    private void logUnnecessaryPackages(PackageTally compileJarsPackages, Set<String> exportedPackagesFromProvidedDeps) {
        Sets.SetView unnecessaryPackages = Sets.intersection(compileJarsPackages.definedPackages(), exportedPackagesFromProvidedDeps);
        if (!unnecessaryPackages.isEmpty()) {
            this.getLog().info((CharSequence)("Compile scoped jars contain the following packages that are most likely available from jdisc runtime: " + (Set)unnecessaryPackages));
        }
    }

    private static String trimWhitespace(Optional<String> lines) {
        return Stream.of(lines.orElse("").split(",")).map(String::trim).collect(Collectors.joining(","));
    }

    private void warnOnUnsupportedArtifacts(Collection<Artifact> nonJarArtifacts) {
        List<Artifact> unsupportedArtifacts = nonJarArtifacts.stream().filter(a -> !a.getType().equals("pom")).collect(Collectors.toList());
        unsupportedArtifacts.forEach(artifact -> this.getLog().warn((CharSequence)String.format("Unsupported artifact '%s': Type '%s' is not supported. Please file a feature request.", artifact.getId(), artifact.getType())));
    }

    private void warnIfInternalContainerArtifactsAreIncluded(Collection<Artifact> includedArtifacts) throws MojoExecutionException {
        if (includedArtifacts.stream().anyMatch(this::isJdiscComponentArtifact)) {
            throw new MojoExecutionException("This project includes the 'com.yahoo.vespa:component' artifact in compile scope. It must have scope 'provided' to avoid resource leaks in your application at runtime. Please use 'mvn dependency:tree' to find the root cause.");
        }
    }

    private boolean isJdiscComponentArtifact(Artifact a) {
        return a.getArtifactId().equals("component") && a.getGroupId().equals("com.yahoo.vespa");
    }

    private PackageTally getProjectClassesTally() {
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        List<ClassFileMetaData> analyzedClasses = Files.allDescendantFiles(outputDirectory).filter(file -> file.getName().endsWith(".class")).map(classFile -> Analyze.analyzeClass(classFile, this.artifactVersionOrNull(this.bundleVersion))).collect(Collectors.toList());
        return PackageTally.fromAnalyzedClassFiles(analyzedClasses);
    }
}

