/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.util;

import com.yahoo.container.plugin.util.ThrowingFunction;
import java.io.File;
import java.io.FileOutputStream;
import java.util.stream.Stream;

public class Files {
    public static Stream<File> allDescendantFiles(File file) {
        if (file.isFile()) {
            return Stream.of(file);
        }
        if (file.isDirectory()) {
            return Stream.of(file.listFiles()).flatMap(Files::allDescendantFiles);
        }
        return Stream.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withFileOutputStream(File file, ThrowingFunction<FileOutputStream, T> f) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            FileOutputStream fileOutputStream = f.apply(fos);
            return (T)fileOutputStream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

