/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class Artifacts {
    public static ArtifactSet getArtifacts(MavenProject project) {
        ArrayList<Artifact> jarArtifactsToInclude = new ArrayList<Artifact>();
        ArrayList<Artifact> jarArtifactsProvided = new ArrayList<Artifact>();
        ArrayList<Object> nonJarArtifactsToInclude = new ArrayList<Object>();
        ArrayList<Artifact> nonJarArtifactsProvided = new ArrayList<Artifact>();
        for (Artifact artifact : project.getArtifacts()) {
            if ("jar".equals(artifact.getType())) {
                if ("compile".equals(artifact.getScope())) {
                    jarArtifactsToInclude.add(artifact);
                    continue;
                }
                if (!"provided".equals(artifact.getScope())) continue;
                jarArtifactsProvided.add(artifact);
                continue;
            }
            if ("compile".equals(artifact.getScope())) {
                nonJarArtifactsToInclude.add(artifact);
                continue;
            }
            if (!"provided".equals(artifact.getScope())) continue;
            nonJarArtifactsProvided.add(artifact);
        }
        nonJarArtifactsToInclude.addAll(nonJarArtifactsProvided);
        return new ArtifactSet(jarArtifactsToInclude, jarArtifactsProvided, nonJarArtifactsToInclude);
    }

    public static Collection<Artifact> getArtifactsToInclude(MavenProject project) {
        return Artifacts.getArtifacts(project).getJarArtifactsToInclude();
    }

    public static class ArtifactSet {
        private final List<Artifact> jarArtifactsToInclude;
        private final List<Artifact> jarArtifactsProvided;
        private final List<Artifact> nonJarArtifacts;

        private ArtifactSet(List<Artifact> jarArtifactsToInclude, List<Artifact> jarArtifactsProvided, List<Artifact> nonJarArtifacts) {
            this.jarArtifactsToInclude = jarArtifactsToInclude;
            this.jarArtifactsProvided = jarArtifactsProvided;
            this.nonJarArtifacts = nonJarArtifacts;
        }

        public List<Artifact> getJarArtifactsToInclude() {
            return this.jarArtifactsToInclude;
        }

        public List<Artifact> getJarArtifactsProvided() {
            return this.jarArtifactsProvided;
        }

        public List<Artifact> getNonJarArtifacts() {
            return this.nonJarArtifacts;
        }
    }
}

