/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.classanalysis;

import com.yahoo.container.plugin.classanalysis.AnalyzeClassVisitor;
import com.yahoo.container.plugin.classanalysis.ImportCollector;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

class AnalyzeSignatureVisitor
extends SignatureVisitor
implements ImportCollector {
    private final AnalyzeClassVisitor analyzeClassVisitor;
    private Set<String> imports = new HashSet<String>();

    AnalyzeSignatureVisitor(AnalyzeClassVisitor analyzeClassVisitor) {
        super(393216);
        this.analyzeClassVisitor = analyzeClassVisitor;
    }

    @Override
    public Set<String> imports() {
        return this.imports;
    }

    public void visitEnd() {
        super.visitEnd();
        this.analyzeClassVisitor.addImports(this.imports);
    }

    public void visitClassType(String className) {
        this.addImportWithInternalName(className);
    }

    public void visitFormalTypeParameter(String name) {
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        return this;
    }

    public SignatureVisitor visitReturnType() {
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        return this;
    }

    public void visitBaseType(char descriptor) {
    }

    public void visitTypeVariable(String name) {
    }

    public SignatureVisitor visitArrayType() {
        return this;
    }

    public void visitInnerClassType(String name) {
    }

    public void visitTypeArgument() {
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        return this;
    }

    static void analyzeClass(String signature, AnalyzeClassVisitor analyzeClassVisitor) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)new AnalyzeSignatureVisitor(analyzeClassVisitor));
        }
    }

    static void analyzeMethod(String signature, AnalyzeClassVisitor analyzeClassVisitor) {
        AnalyzeSignatureVisitor.analyzeClass(signature, analyzeClassVisitor);
    }

    static void analyzeField(String signature, AnalyzeClassVisitor analyzeClassVisitor) {
        if (signature != null) {
            new SignatureReader(signature).acceptType((SignatureVisitor)new AnalyzeSignatureVisitor(analyzeClassVisitor));
        }
    }
}

