/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.bundle;

import com.yahoo.container.plugin.osgi.ExportPackages;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TransformExportPackages {
    public static List<ExportPackages.Export> replaceVersions(List<ExportPackages.Export> exports, String newVersion) {
        ArrayList<ExportPackages.Export> ret = new ArrayList<ExportPackages.Export>();
        for (ExportPackages.Export export : exports) {
            ArrayList<ExportPackages.Parameter> newParams = new ArrayList<ExportPackages.Parameter>();
            for (ExportPackages.Parameter param : export.getParameters()) {
                if ("version".equals(param.getName())) {
                    newParams.add(new ExportPackages.Parameter("version", newVersion));
                    continue;
                }
                newParams.add(param);
            }
            ret.add(new ExportPackages.Export(export.getPackageNames(), newParams));
        }
        return ret;
    }

    public static List<ExportPackages.Export> removeUses(List<ExportPackages.Export> exports) {
        ArrayList<ExportPackages.Export> ret = new ArrayList<ExportPackages.Export>();
        for (ExportPackages.Export export : exports) {
            ArrayList<ExportPackages.Parameter> newParams = new ArrayList<ExportPackages.Parameter>();
            for (ExportPackages.Parameter param : export.getParameters()) {
                if ("uses".equals(param.getName())) continue;
                newParams.add(param);
            }
            ret.add(new ExportPackages.Export(export.getPackageNames(), newParams));
        }
        return ret;
    }

    public static String toExportPackageProperty(List<ExportPackages.Export> exports) {
        return exports.stream().map(exp -> {
            String oneExport = String.join((CharSequence)";", exp.getPackageNames());
            if (exp.getParameters().size() > 0) {
                String paramString = exp.getParameters().stream().map(param -> param.getName() + "=" + TransformExportPackages.quote(param.getValue())).collect(Collectors.joining(";"));
                oneExport = oneExport + ";" + paramString;
            }
            return oneExport;
        }).collect(Collectors.joining(","));
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }
}

