/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container;

import com.google.common.util.concurrent.ListenableFuture;
import com.yahoo.api.annotations.Beta;
import com.yahoo.application.container.ProcessingBase;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Chain;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.processing.rendering.Renderer;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.handler.HttpSearchResponse;
import com.yahoo.search.handler.SearchHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@Beta
public final class Search
extends ProcessingBase<Query, Result, Searcher> {
    private final SearchHandler handler;

    Search(SearchHandler handler) {
        this.handler = handler;
    }

    @Override
    public ChainRegistry<Searcher> getChains() {
        return this.asChainRegistry();
    }

    @Override
    protected Result doProcess(Chain<Searcher> chain, Query request) {
        return this.handler.searchAndFill(request, chain);
    }

    @Override
    protected ListenableFuture<Boolean> doProcessAndRender(ComponentSpecification chainSpec, Query request, Renderer<Result> renderer, ByteArrayOutputStream stream) throws IOException {
        Result result = (Result)this.process(chainSpec, request);
        return HttpSearchResponse.waitableRender((Result)result, (Query)result.getQuery(), renderer, (OutputStream)stream);
    }

    @Override
    protected Renderer<Result> doGetRenderer(ComponentSpecification spec) {
        return this.handler.getRendererCopy(spec);
    }

    private ChainRegistry<Searcher> asChainRegistry() {
        ChainRegistry chains = new ChainRegistry();
        for (Chain chain : this.handler.getSearchChainRegistry().allComponents()) {
            chains.register(chain.getId(), (Object)chain);
        }
        chains.freeze();
        return chains;
    }
}

