/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.timegrains;

import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class Second
extends Time {
    public static final String FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss").withZone(ZoneOffset.systemDefault());

    public Second(Date date) {
        super(date, true, true, true, true, true, true, Second.getSerializer(TimeGrain.SECOND));
    }

    public Second(LocalDateTime date) {
        super(date, true, true, true, true, true, true, Second.getSerializer(TimeGrain.SECOND));
    }

    @ElideTypeConverter(type=Second.class, name="Second")
    public static class SecondSerde
    implements Serde<Object, Second> {
        public Second deserialize(Object val) {
            if (val instanceof Date) {
                return new Second((Date)val);
            }
            if (val instanceof OffsetDateTime) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)val;
                return new Second(offsetDateTime.toLocalDateTime());
            }
            return new Second(LocalDateTime.parse(val.toString(), FORMATTER));
        }

        public String serialize(Second val) {
            return val.serializer.format(val);
        }
    }
}

