/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.timegrains;

import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.timegrains.Time;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class ISOWeek
extends Time {
    public static final String FORMAT = "yyyy-MM-dd";

    public ISOWeek(LocalDateTime date) {
        super(date, true, true, true, false, false, false, ISOWeek.getSerializer(TimeGrain.ISOWEEK));
    }

    @ElideTypeConverter(type=ISOWeek.class, name="ISOWeek")
    public static class ISOWeekSerde
    implements Serde<Object, ISOWeek> {
        public ISOWeek deserialize(Object val) {
            LocalDateTime date;
            if (val instanceof Date) {
                date = LocalDateTime.ofInstant(((Date)val).toInstant(), ZoneOffset.systemDefault());
            } else if (val instanceof OffsetDateTime) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)val;
                date = offsetDateTime.toLocalDate().atTime(0, 0);
            } else {
                LocalDate localDate = LocalDate.parse(val.toString(), DateTimeFormatter.ISO_LOCAL_DATE);
                date = localDate.atTime(0, 0);
            }
            if (date.getDayOfWeek() != DayOfWeek.MONDAY) {
                throw new IllegalArgumentException("Date string not a Monday");
            }
            return new ISOWeek(date);
        }

        public String serialize(ISOWeek val) {
            return val.serializer.format(val);
        }
    }
}

