/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation;

import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.ArgumentType;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.checks.FilterExpressionCheck;
import com.yahoo.elide.core.security.checks.UserCheck;
import com.yahoo.elide.core.security.executors.AggregationStorePermissionExecutor;
import com.yahoo.elide.core.type.AccessibleObject;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.AggregationDataStoreTransaction;
import com.yahoo.elide.datastores.aggregation.QueryEngine;
import com.yahoo.elide.datastores.aggregation.annotation.ColumnMeta;
import com.yahoo.elide.datastores.aggregation.annotation.Join;
import com.yahoo.elide.datastores.aggregation.annotation.TableMeta;
import com.yahoo.elide.datastores.aggregation.cache.Cache;
import com.yahoo.elide.datastores.aggregation.core.QueryLogger;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.ArgumentDefinition;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimension;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromSubquery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromTable;
import com.yahoo.elide.modelconfig.validator.PermissionExpressionVisitor;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class AggregationDataStore
implements DataStore {
    @NonNull
    private final QueryEngine queryEngine;
    private final Cache cache;
    private final Set<Type<?>> dynamicCompiledClasses;
    private final QueryLogger queryLogger;
    public static final Predicate<AccessibleObject> IS_FIELD_HIDDEN = field -> {
        ColumnMeta meta = (ColumnMeta)field.getAnnotation(ColumnMeta.class);
        Join join = (Join)field.getAnnotation(Join.class);
        return join != null || meta != null && meta.isHidden();
    };
    public static final Predicate<Type<?>> IS_TYPE_HIDDEN = type -> {
        TableMeta meta = (TableMeta)type.getAnnotation(TableMeta.class);
        return meta != null && meta.isHidden();
    };
    private final Function<RequestScope, PermissionExecutor> aggPermissionExecutor = AggregationStorePermissionExecutor::new;
    private static final List<Class<? extends Annotation>> AGGREGATION_STORE_CLASSES = Arrays.asList(FromTable.class, FromSubquery.class);

    public void populateEntityDictionary(EntityDictionary dictionary) {
        if (this.dynamicCompiledClasses != null && this.dynamicCompiledClasses.size() != 0) {
            this.dynamicCompiledClasses.stream().filter(type -> !IS_TYPE_HIDDEN.test((Type<?>)type)).forEach(dynamicLoadedClass -> {
                dictionary.bindEntity(dynamicLoadedClass, IS_FIELD_HIDDEN);
                this.validateModelExpressionChecks(dictionary, (Type<?>)dynamicLoadedClass);
                dictionary.bindPermissionExecutor(dynamicLoadedClass, this.aggPermissionExecutor);
            });
        }
        dictionary.getScanner().getAnnotatedClasses(AGGREGATION_STORE_CLASSES).stream().filter(type -> !IS_TYPE_HIDDEN.test((Type<?>)ClassType.of((Class)type))).forEach(cls -> {
            dictionary.bindEntity(cls, IS_FIELD_HIDDEN);
            this.validateModelExpressionChecks(dictionary, (Type<?>)ClassType.of((Class)cls));
            dictionary.bindPermissionExecutor(cls, this.aggPermissionExecutor);
        });
        for (Table table : this.queryEngine.getMetaDataStore().getMetaData(ClassType.of(Table.class))) {
            for (TimeDimension timeDim : table.getAllTimeDimensions()) {
                dictionary.addArgumentToAttribute(dictionary.getEntityClass(table.getName(), table.getVersion()), timeDim.getName(), new ArgumentType("grain", (Type)ClassType.STRING_TYPE, (Object)timeDim.getDefaultGrain().getGrain()));
            }
            for (Column col : table.getAllColumns()) {
                for (ArgumentDefinition arg : col.getArgumentDefinitions()) {
                    dictionary.addArgumentToAttribute(dictionary.getEntityClass(table.getName(), table.getVersion()), col.getName(), new ArgumentType(arg.getName(), ValueType.getType(arg.getType()), arg.getDefaultValue()));
                }
            }
            for (ArgumentDefinition arg : table.getArgumentDefinitions()) {
                dictionary.addArgumentToEntity(dictionary.getEntityClass(table.getName(), table.getVersion()), new ArgumentType(arg.getName(), ValueType.getType(arg.getType()), arg.getDefaultValue()));
            }
        }
    }

    public DataStoreTransaction beginTransaction() {
        return new AggregationDataStoreTransaction(this.queryEngine, this.cache, this.queryLogger);
    }

    private void validateModelExpressionChecks(EntityDictionary dictionary, Type<?> clz) {
        PermissionExpressionVisitor visitor = new PermissionExpressionVisitor();
        ParseTree parseTree = dictionary.getPermissionsForClass(clz, ReadPermission.class);
        if (parseTree != null) {
            this.validateExpression(dictionary, (Set)visitor.visit(parseTree), checkClass -> UserCheck.class.isAssignableFrom((Class<?>)checkClass) || FilterExpressionCheck.class.isAssignableFrom((Class<?>)checkClass), "Table Can only have User Check and Filter Expression Check.Operation Checks Not allowed. given - %s");
        }
        dictionary.getAllExposedFields(clz).stream().map(field -> dictionary.getPermissionsForField(clz, field, ReadPermission.class)).filter(Objects::nonNull).forEach(tree -> this.validateExpression(dictionary, (Set)visitor.visit(tree), checkClass -> UserCheck.class.isAssignableFrom((Class<?>)checkClass), "Fields Can only have User checks. Given - %s"));
    }

    private void validateExpression(EntityDictionary dictionary, Set<String> expressionChecksIdentifiers, Predicate<Class> validCheckPredicate, String errorMsgFormat) throws IllegalStateException {
        expressionChecksIdentifiers.stream().filter(check -> dictionary.getRoleCheck(check) == null).forEach(check -> {
            Class checkClass = dictionary.getCheck(check);
            if (!validCheckPredicate.test(checkClass)) {
                throw new IllegalStateException(String.format(errorMsgFormat, "(" + check + "-" + checkClass + ")"));
            }
        });
    }

    public static final boolean isAggregationStoreModel(Type<?> model) {
        return AGGREGATION_STORE_CLASSES.stream().anyMatch(annotation -> model.getDeclaredAnnotation(annotation) != null);
    }

    AggregationDataStore(@NonNull QueryEngine queryEngine, Cache cache, Set<Type<?>> dynamicCompiledClasses, QueryLogger queryLogger) {
        if (queryEngine == null) {
            throw new NullPointerException("queryEngine is marked non-null but is null");
        }
        this.queryEngine = queryEngine;
        this.cache = cache;
        this.dynamicCompiledClasses = dynamicCompiledClasses;
        this.queryLogger = queryLogger;
    }

    public static AggregationDataStoreBuilder builder() {
        return new AggregationDataStoreBuilder();
    }

    public String toString() {
        return "AggregationDataStore(queryEngine=" + this.queryEngine + ", cache=" + this.cache + ", dynamicCompiledClasses=" + this.dynamicCompiledClasses + ", queryLogger=" + this.queryLogger + ", aggPermissionExecutor=" + this.aggPermissionExecutor + ")";
    }

    public static class AggregationDataStoreBuilder {
        private QueryEngine queryEngine;
        private Cache cache;
        private Set<Type<?>> dynamicCompiledClasses;
        private QueryLogger queryLogger;

        AggregationDataStoreBuilder() {
        }

        public AggregationDataStoreBuilder queryEngine(@NonNull QueryEngine queryEngine) {
            if (queryEngine == null) {
                throw new NullPointerException("queryEngine is marked non-null but is null");
            }
            this.queryEngine = queryEngine;
            return this;
        }

        public AggregationDataStoreBuilder cache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public AggregationDataStoreBuilder dynamicCompiledClasses(Set<Type<?>> dynamicCompiledClasses) {
            this.dynamicCompiledClasses = dynamicCompiledClasses;
            return this;
        }

        public AggregationDataStoreBuilder queryLogger(QueryLogger queryLogger) {
            this.queryLogger = queryLogger;
            return this;
        }

        public AggregationDataStore build() {
            return new AggregationDataStore(this.queryEngine, this.cache, this.dynamicCompiledClasses, this.queryLogger);
        }

        public String toString() {
            return "AggregationDataStore.AggregationDataStoreBuilder(queryEngine=" + this.queryEngine + ", cache=" + this.cache + ", dynamicCompiledClasses=" + this.dynamicCompiledClasses + ", queryLogger=" + this.queryLogger + ")";
        }
    }
}

