/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    public static final Unsafe unsafe;
    public static final int ADDRESS_SIZE;
    public static final int ARRAY_BOOLEAN_BASE_OFFSET;
    public static final int ARRAY_BYTE_BASE_OFFSET;
    public static final int ARRAY_SHORT_BASE_OFFSET;
    public static final int ARRAY_CHAR_BASE_OFFSET;
    public static final int ARRAY_INT_BASE_OFFSET;
    public static final int ARRAY_LONG_BASE_OFFSET;
    public static final int ARRAY_FLOAT_BASE_OFFSET;
    public static final int ARRAY_DOUBLE_BASE_OFFSET;
    public static final int ARRAY_OBJECT_BASE_OFFSET;
    public static final int ARRAY_BOOLEAN_INDEX_SCALE;
    public static final int ARRAY_BYTE_INDEX_SCALE;
    public static final int ARRAY_SHORT_INDEX_SCALE;
    public static final int ARRAY_CHAR_INDEX_SCALE;
    public static final int ARRAY_INT_INDEX_SCALE;
    public static final int ARRAY_LONG_INDEX_SCALE;
    public static final int ARRAY_FLOAT_INDEX_SCALE;
    public static final int ARRAY_DOUBLE_INDEX_SCALE;
    public static final int ARRAY_OBJECT_INDEX_SCALE;
    public static final int BOOLEAN_SHIFT = 0;
    public static final int BYTE_SHIFT = 0;
    public static final int SHORT_SHIFT = 1;
    public static final int CHAR_SHIFT = 1;
    public static final int INT_SHIFT = 2;
    public static final int LONG_SHIFT = 3;
    public static final int FLOAT_SHIFT = 2;
    public static final int DOUBLE_SHIFT = 3;
    public static final String LS;
    public static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    private UnsafeUtil() {
    }

    public static void assertBounds(long reqOff, long reqLen, long allocSize) {
        assert ((reqOff | reqLen | reqOff + reqLen | allocSize - (reqOff + reqLen)) >= 0L) : "reqOffset: " + reqOff + ", reqLength: " + reqLen + ", (reqOff + reqLen): " + (reqOff + reqLen) + ", allocSize: " + allocSize;
    }

    public static void checkBounds(long reqOff, long reqLen, long allocSize) {
        if ((reqOff | reqLen | reqOff + reqLen | allocSize - (reqOff + reqLen)) < 0L) {
            throw new IllegalArgumentException("reqOffset: " + reqOff + ", reqLength: " + ", (reqOff + reqLen): " + (reqOff + reqLen) + ", allocSize: " + allocSize);
        }
    }

    public static boolean checkOverlap(long srcOff, long dstOff, long length) {
        long max;
        long min = Math.min(srcOff, dstOff);
        return min + length <= (max = Math.max(srcOff, dstOff));
    }

    static {
        LS = System.getProperty("line.separator");
        try {
            Constructor unsafeConstructor = Unsafe.class.getDeclaredConstructor(new Class[0]);
            unsafeConstructor.setAccessible(true);
            unsafe = (Unsafe)unsafeConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to acquire Unsafe. ", e);
        }
        ADDRESS_SIZE = unsafe.addressSize();
        ARRAY_BOOLEAN_BASE_OFFSET = unsafe.arrayBaseOffset(boolean[].class);
        ARRAY_BYTE_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        ARRAY_SHORT_BASE_OFFSET = unsafe.arrayBaseOffset(short[].class);
        ARRAY_CHAR_BASE_OFFSET = unsafe.arrayBaseOffset(char[].class);
        ARRAY_INT_BASE_OFFSET = unsafe.arrayBaseOffset(int[].class);
        ARRAY_LONG_BASE_OFFSET = unsafe.arrayBaseOffset(long[].class);
        ARRAY_FLOAT_BASE_OFFSET = unsafe.arrayBaseOffset(float[].class);
        ARRAY_DOUBLE_BASE_OFFSET = unsafe.arrayBaseOffset(double[].class);
        ARRAY_OBJECT_BASE_OFFSET = unsafe.arrayBaseOffset(Object[].class);
        ARRAY_BOOLEAN_INDEX_SCALE = unsafe.arrayIndexScale(boolean[].class);
        ARRAY_BYTE_INDEX_SCALE = unsafe.arrayIndexScale(byte[].class);
        ARRAY_SHORT_INDEX_SCALE = unsafe.arrayIndexScale(short[].class);
        ARRAY_CHAR_INDEX_SCALE = unsafe.arrayIndexScale(char[].class);
        ARRAY_INT_INDEX_SCALE = unsafe.arrayIndexScale(int[].class);
        ARRAY_LONG_INDEX_SCALE = unsafe.arrayIndexScale(long[].class);
        ARRAY_FLOAT_INDEX_SCALE = unsafe.arrayIndexScale(float[].class);
        ARRAY_DOUBLE_INDEX_SCALE = unsafe.arrayIndexScale(double[].class);
        ARRAY_OBJECT_INDEX_SCALE = unsafe.arrayIndexScale(Object[].class);
    }
}

