/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.AccessByteBuffer;
import com.yahoo.memory.Buffer;
import com.yahoo.memory.Prim;
import com.yahoo.memory.ReadOnlyException;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.WritableBufferImpl;
import com.yahoo.memory.WritableMemory;
import java.nio.ByteBuffer;

public abstract class WritableBuffer
extends Buffer {
    WritableBuffer(ResourceState state) {
        super(state);
    }

    public static WritableBuffer wrap(ByteBuffer byteBuf) {
        if (byteBuf.isReadOnly()) {
            throw new ReadOnlyException("ByteBuffer is read-only.");
        }
        if (byteBuf.capacity() == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        ResourceState state = new ResourceState();
        state.putByteBuffer(byteBuf);
        AccessByteBuffer.wrap(state);
        WritableBufferImpl impl = new WritableBufferImpl(state);
        impl.setStartPositionEnd(0L, byteBuf.position(), byteBuf.limit());
        return impl;
    }

    public abstract WritableBuffer writableDuplicate();

    public abstract WritableBuffer writableRegion();

    public abstract WritableBuffer writableRegion(long var1, long var3);

    public abstract WritableMemory asWritableMemory();

    public static WritableBuffer allocate(int capacityBytes) {
        if (capacityBytes == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        byte[] arr = new byte[capacityBytes];
        return new WritableBufferImpl(new ResourceState(arr, Prim.BYTE, arr.length));
    }

    public static WritableBuffer wrap(boolean[] arr) {
        if (arr != null && arr.length == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        return new WritableBufferImpl(new ResourceState(arr, Prim.BOOLEAN, arr.length));
    }

    public static WritableBuffer wrap(byte[] arr) {
        if (arr != null && arr.length == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        return new WritableBufferImpl(new ResourceState(arr, Prim.BYTE, arr.length));
    }

    public static WritableBuffer wrap(char[] arr) {
        if (arr != null && arr.length == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        return new WritableBufferImpl(new ResourceState(arr, Prim.CHAR, arr.length));
    }

    public static WritableBuffer wrap(short[] arr) {
        if (arr != null && arr.length == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        return new WritableBufferImpl(new ResourceState(arr, Prim.SHORT, arr.length));
    }

    public static WritableBuffer wrap(int[] arr) {
        if (arr != null && arr.length == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        return new WritableBufferImpl(new ResourceState(arr, Prim.INT, arr.length));
    }

    public static WritableBuffer wrap(long[] arr) {
        if (arr != null && arr.length == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        return new WritableBufferImpl(new ResourceState(arr, Prim.LONG, arr.length));
    }

    public static WritableBuffer wrap(float[] arr) {
        if (arr != null && arr.length == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        return new WritableBufferImpl(new ResourceState(arr, Prim.FLOAT, arr.length));
    }

    public static WritableBuffer wrap(double[] arr) {
        if (arr != null && arr.length == 0) {
            return WritableBufferImpl.ZERO_SIZE_BUFFER;
        }
        return new WritableBufferImpl(new ResourceState(arr, Prim.DOUBLE, arr.length));
    }

    public abstract void putBoolean(boolean var1);

    public abstract void putBoolean(long var1, boolean var3);

    public abstract void putBooleanArray(boolean[] var1, int var2, int var3);

    public abstract void putByte(byte var1);

    public abstract void putByte(long var1, byte var3);

    public abstract void putByteArray(byte[] var1, int var2, int var3);

    public abstract void putChar(char var1);

    public abstract void putChar(long var1, char var3);

    public abstract void putCharArray(char[] var1, int var2, int var3);

    public abstract void putDouble(double var1);

    public abstract void putDouble(long var1, double var3);

    public abstract void putDoubleArray(double[] var1, int var2, int var3);

    public abstract void putFloat(float var1);

    public abstract void putFloat(long var1, float var3);

    public abstract void putFloatArray(float[] var1, int var2, int var3);

    public abstract void putInt(int var1);

    public abstract void putInt(long var1, int var3);

    public abstract void putIntArray(int[] var1, int var2, int var3);

    public abstract void putLong(long var1);

    public abstract void putLong(long var1, long var3);

    public abstract void putLongArray(long[] var1, int var2, int var3);

    public abstract void putShort(short var1);

    public abstract void putShort(long var1, short var3);

    public abstract void putShortArray(short[] var1, int var2, int var3);

    public abstract Object getArray();

    public abstract ByteBuffer getByteBuffer();

    public abstract void clear();

    public abstract void fill(byte var1);

    public abstract long getRegionOffset();
}

