/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.xujl.task.Logger;
import com.xujl.task.Task;
import java.lang.ref.WeakReference;

class RxHandler
extends Handler {
    private static final String TAG = "RxHandler";
    private WeakReference<Task> mTaskWeakReference;

    RxHandler(Task task) {
        super(Looper.getMainLooper());
        this.mTaskWeakReference = new WeakReference<Task>(task);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (this.mTaskWeakReference == null) {
            Log.d((String)TAG, (String)"Task:  mTaskWeakReference.isDestroy");
            return;
        }
        Task task = (Task)this.mTaskWeakReference.get();
        if (task == null) {
            Log.d((String)TAG, (String)"Task:  task.isDestroy");
            return;
        }
        try {
            switch (msg.what) {
                case -1: {
                    task.onError((Exception)msg.obj);
                    break;
                }
                case 0: {
                    task.onNext(msg.obj);
                    break;
                }
                case 2: {
                    task.onlyRunUiTask();
                    break;
                }
                case 1: {
                    task.onFinished();
                    this.mTaskWeakReference = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.e(TAG, e);
        }
    }
}

