/*
 * Decompiled with CFR 0.152.
 */
package com.xujl.task;

import com.xujl.task.Emitter;
import com.xujl.task.Logger;
import com.xujl.task.Task;
import com.xujl.task.TaskCallable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class RxExecutor {
    private ExecutorService mExecutor;

    private RxExecutor() {
    }

    public <T> void executeTask(Task<T> task) {
        TaskCallable thread = new TaskCallable();
        this.executeTask(thread, task);
    }

    public <T> void executeTask(TaskCallable<T> thread, Task<T> task) {
        thread.setTask(task);
        Future<T> submit = this.mExecutor.submit(thread);
        task.setFuture(submit);
    }

    public void executeUiTask(Task task) {
        Emitter emitter = task.getEmitter();
        if (emitter != null) {
            emitter.runUi();
        }
    }

    public void init() {
        int processors = Runtime.getRuntime().availableProcessors();
        this.init(processors);
    }

    public void init(int corePoolSize) {
        this.mExecutor = Executors.newScheduledThreadPool(corePoolSize, Executors.defaultThreadFactory());
    }

    public void setDebug(boolean isDebug) {
        Logger.sIsDebug = isDebug;
    }

    public static RxExecutor getInstance() {
        return Holder.RX_EXECUTOR;
    }

    private static class Holder {
        private static final RxExecutor RX_EXECUTOR = new RxExecutor();

        private Holder() {
        }
    }
}

