/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.client.ssl;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.reficio.ws.client.core.Security;
import org.reficio.ws.client.ssl.MultiX509TrustManager;

public class SSLUtils {
    public static X509TrustManager getTrustManager(KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
    }

    public static X509KeyManager getKeyManager(KeyStore keyStore, char[] keyStorePassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        return (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
    }

    public static X509TrustManager getMultiTrustManager(X509TrustManager ... managers) {
        ArrayList<X509TrustManager> managersList = new ArrayList<X509TrustManager>();
        for (X509TrustManager manager : managers) {
            managersList.add(manager);
        }
        return new MultiX509TrustManager(managersList);
    }

    public static SSLSocketFactory getMergedSocketFactory(Security securityOne, Security securityTwo) throws GeneralSecurityException {
        X509KeyManager keyManagerOne = SSLUtils.getKeyManager(securityOne.getKeyStore(), securityOne.getKeyStorePassword());
        X509KeyManager keyManagerTwo = SSLUtils.getKeyManager(securityTwo.getKeyStore(), securityTwo.getKeyStorePassword());
        X509TrustManager trustManager = SSLUtils.getMultiTrustManager(SSLUtils.getTrustManager(securityOne.getTrustStore()), SSLUtils.getTrustManager(securityTwo.getTrustStore()));
        SSLContext context = SSLContext.getInstance(securityOne.getSslContextProtocol());
        boolean strictHostVerification = securityOne.isStrictHostVerification() && securityTwo.isStrictHostVerification();
        context.init(new KeyManager[]{keyManagerOne, keyManagerTwo}, new TrustManager[]{trustManager}, new SecureRandom());
        X509HostnameVerifier verifier = strictHostVerification ? SSLSocketFactory.STRICT_HOSTNAME_VERIFIER : SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        return new SSLSocketFactory(context, verifier);
    }

    public static SSLSocketFactory getFactory(Security security) throws GeneralSecurityException {
        X509HostnameVerifier verifier = security.isStrictHostVerification() ? SSLSocketFactory.STRICT_HOSTNAME_VERIFIER : SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SSLSocketFactory socketFactory = new SSLSocketFactory(security.getSslContextProtocol(), security.getKeyStore(), security.getKeyStorePasswordAsString(), security.getTrustStore(), new SecureRandom(), null, verifier);
        return socketFactory;
    }
}

