/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.treewalk;

import com.xenoterracide.gradle.semver.jgit.annotations.Nullable;
import com.xenoterracide.gradle.semver.jgit.errors.CorruptObjectException;
import com.xenoterracide.gradle.semver.jgit.lib.FileMode;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectReader;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.treewalk.AbstractTreeIterator;
import com.xenoterracide.gradle.semver.jgit.treewalk.TreeWalk;
import java.io.IOException;

public class NameConflictTreeWalk
extends TreeWalk {
    private static final int TREE_MODE = FileMode.TREE.getBits();
    private boolean allTreesNamesMatchFastMinRef;
    private AbstractTreeIterator dfConflict;

    public NameConflictTreeWalk(Repository repo) {
        super(repo);
    }

    public NameConflictTreeWalk(@Nullable Repository repo, ObjectReader or) {
        super(repo, or);
    }

    public NameConflictTreeWalk(ObjectReader or) {
        super(or);
    }

    @Override
    AbstractTreeIterator min() throws CorruptObjectException {
        AbstractTreeIterator minRef;
        block4: {
            block0: while (true) {
                minRef = this.fastMin();
                if (this.allTreesNamesMatchFastMinRef) {
                    return minRef;
                }
                if (!NameConflictTreeWalk.isTree(minRef)) break block4;
                if (!this.skipEntry(minRef)) break;
                AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
                int n = this.trees.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    AbstractTreeIterator t = abstractTreeIteratorArray[n2];
                    if (t.matches == minRef) {
                        t.next(1);
                        t.matches = null;
                    }
                    ++n2;
                }
                break;
            }
            return minRef;
        }
        return this.combineDF(minRef);
    }

    private AbstractTreeIterator fastMin() {
        int i = this.getFirstNonEofTreeIndex();
        if (i == -1) {
            this.allTreesNamesMatchFastMinRef = true;
            return this.trees[this.trees.length - 1];
        }
        AbstractTreeIterator minRef = this.trees[i];
        this.allTreesNamesMatchFastMinRef = i == 0;
        boolean hasConflict = false;
        minRef.matches = minRef;
        while (++i < this.trees.length) {
            AbstractTreeIterator t = this.trees[i];
            if (t.eof()) {
                this.allTreesNamesMatchFastMinRef = false;
                continue;
            }
            int cmp = t.pathCompare(minRef);
            if (cmp < 0) {
                if (this.allTreesNamesMatchFastMinRef && NameConflictTreeWalk.isTree(minRef) && !NameConflictTreeWalk.isTree(t) && NameConflictTreeWalk.nameEqual(minRef, t)) {
                    t.matches = minRef;
                    hasConflict = true;
                    continue;
                }
                this.allTreesNamesMatchFastMinRef = false;
                t.matches = t;
                minRef = t;
                continue;
            }
            if (cmp == 0) {
                t.matches = minRef;
                continue;
            }
            if (this.allTreesNamesMatchFastMinRef && NameConflictTreeWalk.isTree(t) && !NameConflictTreeWalk.isTree(minRef) && !this.isGitlink(minRef) && NameConflictTreeWalk.nameEqual(t, minRef)) {
                int k = 0;
                while (k < i) {
                    AbstractTreeIterator p = this.trees[k];
                    if (p.matches == minRef) {
                        p.matches = t;
                    }
                    ++k;
                }
                t.matches = t;
                minRef = t;
                hasConflict = true;
                continue;
            }
            this.allTreesNamesMatchFastMinRef = false;
        }
        if (hasConflict && this.allTreesNamesMatchFastMinRef && this.dfConflict == null) {
            this.dfConflict = minRef;
        }
        return minRef;
    }

    private int getFirstNonEofTreeIndex() {
        int i = 0;
        while (i < this.trees.length) {
            if (!this.trees[i].eof()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean nameEqual(AbstractTreeIterator a, AbstractTreeIterator b) {
        return a.pathCompare(b, TREE_MODE) == 0;
    }

    private boolean isGitlink(AbstractTreeIterator p) {
        return FileMode.GITLINK.equals(p.mode);
    }

    private static boolean isTree(AbstractTreeIterator p) {
        return FileMode.TREE.equals(p.mode);
    }

    private boolean skipEntry(AbstractTreeIterator minRef) throws CorruptObjectException {
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTreeIterator t = abstractTreeIteratorArray[n2];
            if (t.matches != minRef && !t.first()) {
                int cmp;
                int stepsBack = 0;
                do {
                    ++stepsBack;
                    t.back(1);
                    cmp = t.pathCompare(minRef, 0);
                    if (cmp != 0) continue;
                    t.next(stepsBack);
                    return true;
                } while (cmp >= 0 && !t.first());
                t.next(stepsBack);
            }
            ++n2;
        }
        return false;
    }

    private AbstractTreeIterator combineDF(AbstractTreeIterator minRef) throws CorruptObjectException {
        AbstractTreeIterator t;
        AbstractTreeIterator treeMatch = null;
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                t = abstractTreeIteratorArray[n2];
                if (t.matches != minRef && !t.eof()) {
                    int cmp;
                    while ((cmp = t.pathCompare(minRef, TREE_MODE)) < 0) {
                        ++t.matchShift;
                        t.next(1);
                        if (!t.eof()) continue;
                        t.back(t.matchShift);
                        t.matchShift = 0;
                        break block12;
                    }
                    if (cmp == 0) {
                        t.matches = minRef;
                        treeMatch = t;
                    } else if (t.matchShift != 0) {
                        t.back(t.matchShift);
                        t.matchShift = 0;
                    }
                }
            }
            ++n2;
        }
        abstractTreeIteratorArray = this.trees;
        n = this.trees.length;
        n2 = 0;
        while (n2 < n) {
            t = abstractTreeIteratorArray[n2];
            if (!t.eof() && t.matches != null && t.matches != minRef && !NameConflictTreeWalk.nameEqual(t, t.matches)) {
                t.matches = null;
            }
            ++n2;
        }
        if (treeMatch != null) {
            abstractTreeIteratorArray = this.trees;
            n = this.trees.length;
            n2 = 0;
            while (n2 < n) {
                t = abstractTreeIteratorArray[n2];
                if (t.matches == minRef) {
                    t.matches = treeMatch;
                }
                ++n2;
            }
            if (this.dfConflict == null && !this.isGitlink(minRef)) {
                this.dfConflict = treeMatch;
            }
            return treeMatch;
        }
        return minRef;
    }

    @Override
    void popEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTreeIterator t = abstractTreeIteratorArray[n2];
            if (t.matches == ch) {
                if (t.matchShift == 0) {
                    t.next(1);
                } else {
                    t.back(t.matchShift);
                    t.matchShift = 0;
                }
                t.matches = null;
            }
            ++n2;
        }
        if (ch == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void skipEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTreeIterator t = abstractTreeIteratorArray[n2];
            if (t.matches == ch) {
                if (t.matchShift == 0) {
                    t.skip();
                } else {
                    t.back(t.matchShift);
                    t.matchShift = 0;
                }
                t.matches = null;
            }
            ++n2;
        }
        if (ch == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void stopWalk() throws IOException {
        if (!this.needsStopWalk()) {
            return;
        }
        while (true) {
            AbstractTreeIterator t;
            if ((t = this.min()).eof()) {
                if (this.depth > 0) {
                    this.exitSubtree();
                    this.popEntriesEqual();
                    continue;
                }
                return;
            }
            this.currentHead = t;
            this.skipEntriesEqual();
        }
    }

    private boolean needsStopWalk() {
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTreeIterator t = abstractTreeIteratorArray[n2];
            if (t.needsStopWalk()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isDirectoryFileConflict() {
        return this.dfConflict != null;
    }
}

