/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport;

import com.xenoterracide.gradle.semver.jgit.lib.BatchingProgressMonitor;
import com.xenoterracide.gradle.semver.jgit.lib.Constants;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;

class SideBandProgressMonitor
extends BatchingProgressMonitor {
    private final OutputStream out;
    private boolean write;

    SideBandProgressMonitor(OutputStream os) {
        this.out = os;
        this.write = true;
    }

    @Override
    protected void onUpdate(String taskName, int workCurr, Duration duration) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr, duration);
        s.append("   \r");
        this.send(s);
    }

    @Override
    protected void onEndTask(String taskName, int workCurr, Duration duration) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr, duration);
        s.append(", done\n");
        this.send(s);
    }

    private void format(StringBuilder s, String taskName, int workCurr, Duration duration) {
        s.append(taskName);
        s.append(": ");
        s.append(workCurr);
        this.appendDuration(s, duration);
    }

    @Override
    protected void onUpdate(String taskName, int cmp, int totalWork, int pcnt, Duration duration) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, cmp, totalWork, pcnt, duration);
        s.append("   \r");
        this.send(s);
    }

    @Override
    protected void onEndTask(String taskName, int cmp, int totalWork, int pcnt, Duration duration) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, cmp, totalWork, pcnt, duration);
        s.append("\n");
        this.send(s);
    }

    private void format(StringBuilder s, String taskName, int cmp, int totalWork, int pcnt, Duration duration) {
        s.append(taskName);
        s.append(": ");
        if (pcnt < 100) {
            s.append(' ');
        }
        if (pcnt < 10) {
            s.append(' ');
        }
        s.append(pcnt);
        s.append("% (");
        s.append(cmp);
        s.append('/');
        s.append(totalWork);
        s.append(')');
        this.appendDuration(s, duration);
    }

    private void send(StringBuilder s) {
        if (this.write) {
            try {
                this.out.write(Constants.encode(s.toString()));
                this.out.flush();
            }
            catch (IOException err) {
                this.write = false;
            }
        }
    }
}

