/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.revwalk;

import com.xenoterracide.gradle.semver.jgit.diff.DiffConfig;
import com.xenoterracide.gradle.semver.jgit.diff.DiffEntry;
import com.xenoterracide.gradle.semver.jgit.diff.RenameDetector;
import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.errors.StopWalkException;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.revwalk.FollowFilter;
import com.xenoterracide.gradle.semver.jgit.revwalk.RenameCallback;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.revwalk.filter.RevFilter;
import com.xenoterracide.gradle.semver.jgit.treewalk.TreeWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.util.List;

public class TreeRevFilter
extends RevFilter {
    private static final int PARSED = 1;
    private static final int UNINTERESTING = 4;
    private static final int FILTER_APPLIED = 128;
    private final int rewriteFlag;
    private final TreeWalk pathFilter;
    private final TreeFilter.MutableBoolean changedPathFilterUsed = new TreeFilter.MutableBoolean();
    private long changedPathFilterTruePositive = 0L;
    private long changedPathFilterFalsePositive = 0L;
    private long changedPathFilterNegative = 0L;

    public TreeRevFilter(RevWalk walker, TreeFilter t) {
        this(walker, t, 0);
    }

    TreeRevFilter(RevWalk walker, TreeFilter t, int rewriteFlag) {
        this.pathFilter = new TreeWalk(walker.reader);
        this.pathFilter.setFilter(t);
        this.pathFilter.setRecursive(t.shouldBeRecursive());
        this.rewriteFlag = rewriteFlag;
    }

    @Override
    public RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean include(RevWalk walker, RevCommit c) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        c.flags |= 128;
        pList = c.getParents();
        nParents = pList.length;
        tw = this.pathFilter;
        trees = new ObjectId[nParents + 1];
        i = 0;
        while (i < nParents) {
            p = c.getParent(i);
            if ((p.flags & 1) == 0) {
                p.parseHeaders(walker);
            }
            trees[i] = p.getTree();
            ++i;
        }
        trees[nParents] = c.getTree();
        tw.reset(trees);
        this.changedPathFilterUsed.reset();
        if (nParents == 1) {
            chgs = 0;
            adds = 0;
            tf = this.pathFilter.getFilter();
            mustCalculateChgs = tf.shouldTreeWalk(c, walker, this.changedPathFilterUsed);
            if (mustCalculateChgs) {
                while (tw.next()) {
                    ++chgs;
                    if (tw.getRawMode(0) != 0 || tw.getRawMode(1) == 0) break;
                    ++adds;
                }
                if (this.changedPathFilterUsed.get()) {
                    if (chgs > 0) {
                        ++this.changedPathFilterTruePositive;
                    } else {
                        ++this.changedPathFilterFalsePositive;
                    }
                }
            } else if (this.changedPathFilterUsed.get()) {
                ++this.changedPathFilterNegative;
            }
            if (chgs == 0) {
                c.flags |= this.rewriteFlag;
                return false;
            }
            if (adds > 0 && tw.getFilter() instanceof FollowFilter) {
                this.updateFollowFilter((ObjectId[])trees, ((FollowFilter)tw.getFilter()).cfg, c);
            }
            return true;
        }
        if (nParents == 0) {
            if (tw.next()) {
                return true;
            }
            c.flags |= this.rewriteFlag;
            return false;
        }
        chgs = new int[nParents];
        adds = new int[nParents];
        while (tw.next()) {
            myMode = tw.getRawMode(nParents);
            i = 0;
            while (i < nParents) {
                pMode = tw.getRawMode(i);
                if (myMode != pMode || !tw.idEqual(i, nParents)) {
                    v0 = i;
                    chgs[v0] = chgs[v0] + 1;
                    if (pMode == 0 && myMode != 0) {
                        v1 = i;
                        adds[v1] = adds[v1] + 1;
                    }
                }
                ++i;
            }
        }
        same = false;
        diff = false;
        i = 0;
        while (i < nParents) {
            if (chgs[i] != 0) ** GOTO lbl75
            p = pList[i];
            if ((p.flags & 4) != 0) {
                same = true;
            } else {
                c.flags |= this.rewriteFlag;
                c.parents = new RevCommit[]{p};
                return false;
lbl75:
                // 1 sources

                if (chgs[i] == adds[i]) {
                    tw.reset((AnyObjectId)pList[i].getTree());
                    if (!tw.next()) {
                        pList[i].parents = RevCommit.NO_PARENTS;
                    }
                }
                diff = true;
            }
            ++i;
        }
        if (diff && !same) {
            return true;
        }
        c.flags |= this.rewriteFlag;
        return false;
    }

    @Override
    public boolean requiresCommitBody() {
        return false;
    }

    public long getChangedPathFilterTruePositive() {
        return this.changedPathFilterTruePositive;
    }

    public long getChangedPathFilterFalsePositive() {
        return this.changedPathFilterFalsePositive;
    }

    public long getChangedPathFilterNegative() {
        return this.changedPathFilterNegative;
    }

    private void updateFollowFilter(ObjectId[] trees, DiffConfig cfg, RevCommit commit) throws IOException {
        TreeWalk tw = this.pathFilter;
        FollowFilter oldFilter = (FollowFilter)tw.getFilter();
        tw.setFilter(TreeFilter.ANY_DIFF);
        tw.reset(trees);
        List<DiffEntry> files = DiffEntry.scan(tw);
        RenameDetector rd = new RenameDetector(tw.getObjectReader(), cfg);
        rd.addAll(files);
        files = rd.compute();
        FollowFilter newFilter = oldFilter;
        for (DiffEntry ent : files) {
            if (!TreeRevFilter.isRename(ent) || !ent.getNewPath().equals(oldFilter.getPath())) continue;
            newFilter = FollowFilter.create(ent.getOldPath(), cfg);
            RenameCallback callback = oldFilter.getRenameCallback();
            if (callback == null) break;
            callback.renamed(ent, commit);
            newFilter.setRenameCallback(callback);
            break;
        }
        tw.setFilter(newFilter);
    }

    private static boolean isRename(DiffEntry ent) {
        return ent.getChangeType() == DiffEntry.ChangeType.RENAME || ent.getChangeType() == DiffEntry.ChangeType.COPY;
    }
}

