/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.revwalk;

import com.xenoterracide.gradle.semver.jgit.diff.DiffConfig;
import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.revwalk.RenameCallback;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.TreeWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.ChangedPathTreeFilter;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;

public class FollowFilter
extends TreeFilter {
    private final ChangedPathTreeFilter path;
    final DiffConfig cfg;
    private RenameCallback renameCallback;

    public static FollowFilter create(String path, DiffConfig cfg) {
        return new FollowFilter(ChangedPathTreeFilter.create(path), cfg);
    }

    FollowFilter(ChangedPathTreeFilter path, DiffConfig cfg) {
        this.path = path;
        this.cfg = cfg;
    }

    public String getPath() {
        return this.path.getPaths().get(0);
    }

    @Override
    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.path.include(walker);
    }

    @Override
    public boolean shouldTreeWalk(RevCommit c, RevWalk rw, TreeFilter.MutableBoolean cpfUsed) {
        return this.path.shouldTreeWalk(c, rw, cpfUsed);
    }

    @Override
    public boolean shouldBeRecursive() {
        return this.path.shouldBeRecursive();
    }

    @Override
    public Optional<Set<byte[]>> getPathsBestEffort() {
        return this.path.getPathsBestEffort();
    }

    @Override
    public TreeFilter clone() {
        return new FollowFilter(this.path.clone(), this.cfg);
    }

    @Override
    public String toString() {
        return "(FOLLOW(" + this.path.toString() + "))";
    }

    public RenameCallback getRenameCallback() {
        return this.renameCallback;
    }

    public void setRenameCallback(RenameCallback callback) {
        this.renameCallback = callback;
    }
}

