/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.merge;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectInserter;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.merge.Merger;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevTree;
import com.xenoterracide.gradle.semver.jgit.treewalk.AbstractTreeIterator;
import com.xenoterracide.gradle.semver.jgit.treewalk.EmptyTreeIterator;
import java.io.IOException;

public abstract class ThreeWayMerger
extends Merger {
    private RevTree baseTree;
    private ObjectId baseCommitId;

    protected ThreeWayMerger(Repository local) {
        super(local);
    }

    protected ThreeWayMerger(Repository local, boolean inCore) {
        this(local);
    }

    protected ThreeWayMerger(ObjectInserter inserter) {
        super(inserter);
    }

    public void setBase(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.baseTree = id != null ? this.walk.parseTree(id) : null;
    }

    @Override
    public boolean merge(AnyObjectId ... tips) throws IOException {
        if (tips.length != 2) {
            return false;
        }
        return super.merge(tips);
    }

    @Override
    public ObjectId getBaseCommitId() {
        return this.baseCommitId;
    }

    protected AbstractTreeIterator mergeBase() throws IOException {
        RevCommit baseCommit;
        if (this.baseTree != null) {
            return this.openTree(this.baseTree);
        }
        RevCommit revCommit = baseCommit = this.baseCommitId != null ? this.walk.parseCommit(this.baseCommitId) : this.getBaseCommit(this.sourceCommits[0], this.sourceCommits[1]);
        if (baseCommit == null) {
            this.baseCommitId = null;
            return new EmptyTreeIterator();
        }
        this.baseCommitId = baseCommit.toObjectId();
        return this.openTree(baseCommit.getTree());
    }
}

