/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.lib;

import com.xenoterracide.gradle.semver.jgit.errors.ConfigInvalidException;
import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.Config;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectLoader;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectReader;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevTree;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.TreeWalk;
import com.xenoterracide.gradle.semver.jgit.util.RawParseUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;

public class BlobBasedConfig
extends Config {
    public BlobBasedConfig(Config base, byte[] blob) throws ConfigInvalidException {
        super(base);
        String decoded = this.isUtf8(blob) ? RawParseUtils.decode(StandardCharsets.UTF_8, blob, 3, blob.length) : RawParseUtils.decode(blob);
        this.fromText(decoded);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId objectId) throws IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, objectId));
    }

    private static byte[] read(Repository db, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectReader or = db.newObjectReader();){
            return BlobBasedConfig.read(or, blobId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] read(ObjectReader or, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader loader = or.open(blobId, 3);
        return loader.getCachedBytes(Integer.MAX_VALUE);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId treeish, String path) throws FileNotFoundException, IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, treeish, path));
    }

    private static byte[] read(Repository db, AnyObjectId treeish, String path) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectReader or = db.newObjectReader();){
            TreeWalk tree = TreeWalk.forPath(or, path, BlobBasedConfig.asTree(or, treeish));
            if (tree == null) {
                throw new FileNotFoundException(MessageFormat.format(JGitText.get().entryNotFoundByPath, path));
            }
            return BlobBasedConfig.read(or, (AnyObjectId)tree.getObjectId(0));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static AnyObjectId asTree(ObjectReader or, AnyObjectId treeish) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (treeish instanceof RevTree) {
            return treeish;
        }
        if (treeish instanceof RevCommit && ((RevCommit)treeish).getTree() != null) {
            return ((RevCommit)treeish).getTree();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk rw = new RevWalk(or);){
            return rw.parseTree(treeish).getId();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

