/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.file;

import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.storage.pack.PackExt;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import java.io.File;
import java.text.MessageFormat;

public class PackFile
extends File {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = "pack-";
    private static final String TMP_GC_PREFIX = ".tmp-";
    private final String base;
    private final String id;
    private final boolean hasOldPrefix;
    private final PackExt packExt;

    private static String createName(String id, PackExt extension) {
        return PREFIX + id + "." + extension.getExtension();
    }

    public PackFile(File file) {
        this(file.getParentFile(), file.getName());
    }

    public PackFile(File directory, ObjectId id, PackExt ext) {
        this(directory, id.name(), ext);
    }

    public PackFile(File directory, String id, PackExt ext) {
        this(directory, PackFile.createName(id, ext));
    }

    public PackFile(File directory, String name) {
        super(directory, name);
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            this.base = name;
            this.hasOldPrefix = false;
            this.packExt = null;
        } else {
            this.base = name.substring(0, dot);
            String tail = name.substring(dot + 1);
            this.packExt = PackFile.getPackExt(tail);
            String old = tail.substring(0, tail.length() - this.getExtension().length());
            this.hasOldPrefix = old.equals(PackFile.getExtPrefix(true));
        }
        this.id = this.base.startsWith(PREFIX) ? this.base.substring(PREFIX.length()) : this.base;
    }

    public String getId() {
        return this.id;
    }

    public PackExt getPackExt() {
        return this.packExt;
    }

    public boolean isTmpGCFile() {
        return this.id.startsWith(TMP_GC_PREFIX);
    }

    public PackFile create(PackExt ext) {
        return new PackFile(this.getParentFile(), this.getName(ext));
    }

    public PackFile createForDirectory(File directory) {
        return new PackFile(directory, this.getName(false));
    }

    public PackFile createPreservedForDirectory(File directory) {
        return new PackFile(directory, this.getName(true));
    }

    private String getName(PackExt ext) {
        return this.base + "." + PackFile.getExtPrefix(this.hasOldPrefix) + ext.getExtension();
    }

    private String getName(boolean isPreserved) {
        return this.base + "." + PackFile.getExtPrefix(isPreserved) + this.getExtension();
    }

    private String getExtension() {
        return this.packExt == null ? "" : this.packExt.getExtension();
    }

    private static String getExtPrefix(boolean isPreserved) {
        return isPreserved ? "old-" : "";
    }

    private static PackExt getPackExt(String endsWithExtension) {
        PackExt[] packExtArray = PackExt.values();
        int n = packExtArray.length;
        int n2 = 0;
        while (n2 < n) {
            PackExt ext = packExtArray[n2];
            if (endsWithExtension.equals(ext.getExtension())) {
                return ext;
            }
            if (endsWithExtension.equals("old-" + ext.getExtension())) {
                return ext;
            }
            ++n2;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().unrecognizedPackExtension, endsWithExtension));
    }
}

