/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.PackBitmapIndexV1;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.PackIndex;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.PackReverseIndex;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.util.io.SilentFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public interface PackBitmapIndex {
    public static final int FLAG_REUSE = 1;

    public static PackBitmapIndex open(File idxFile, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (SilentFileInputStream fd = new SilentFileInputStream(idxFile);){
            return PackBitmapIndex.read(fd, packIndex, reverseIndex);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static PackBitmapIndex read(InputStream fd, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        return new PackBitmapIndexV1(fd, packIndex, reverseIndex);
    }

    public static PackBitmapIndex read(InputStream fd, SupplierWithIOException<PackIndex> packIndexSupplier, SupplierWithIOException<PackReverseIndex> reverseIndexSupplier, boolean loadParallelRevIndex) throws IOException {
        return new PackBitmapIndexV1(fd, packIndexSupplier, reverseIndexSupplier, loadParallelRevIndex);
    }

    default public byte[] getPackChecksum() {
        return null;
    }

    public int findPosition(AnyObjectId var1);

    public ObjectId getObject(int var1) throws IllegalArgumentException;

    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap var1, int var2);

    public EWAHCompressedBitmap getBitmap(AnyObjectId var1);

    public int getObjectCount();

    public int getBitmapCount();

    public int getBaseBitmapCount();

    public long getBaseBitmapSizeInBytes();

    public int getXorBitmapCount();

    public long getXorBitmapSizeInBytes();

    @FunctionalInterface
    public static interface SupplierWithIOException<T> {
        public T get() throws IOException;
    }
}

