/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph;

import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph.CommitGraph;
import com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph.CommitGraphFormatException;
import com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph.CommitGraphV1;
import com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph.GraphChangedPathFilterData;
import com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph.GraphCommitData;
import com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph.GraphObjectIndex;
import java.text.MessageFormat;

class CommitGraphBuilder {
    private final int hashLength;
    private byte[] oidFanout;
    private byte[] oidLookup;
    private byte[] commitData;
    private byte[] extraList;
    private byte[] bloomFilterIndex;
    private byte[] bloomFilterData;

    static CommitGraphBuilder builder() {
        return new CommitGraphBuilder(20);
    }

    private CommitGraphBuilder(int hashLength) {
        this.hashLength = hashLength;
    }

    CommitGraphBuilder addOidFanout(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.oidFanout, 1330201670);
        this.oidFanout = buffer;
        return this;
    }

    CommitGraphBuilder addOidLookUp(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.oidLookup, 1330201676);
        this.oidLookup = buffer;
        return this;
    }

    CommitGraphBuilder addCommitData(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.commitData, 1128546644);
        this.commitData = buffer;
        return this;
    }

    CommitGraphBuilder addExtraList(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.extraList, 0x45444745);
        this.extraList = buffer;
        return this;
    }

    CommitGraphBuilder addBloomFilterIndex(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.bloomFilterIndex, 1112097880);
        this.bloomFilterIndex = buffer;
        return this;
    }

    CommitGraphBuilder addBloomFilterData(byte[] buffer) throws CommitGraphFormatException {
        this.assertChunkNotSeenYet(this.bloomFilterData, 1111769428);
        this.bloomFilterData = buffer;
        return this;
    }

    CommitGraph build() throws CommitGraphFormatException {
        this.assertChunkNotNull(this.oidFanout, 1330201670);
        this.assertChunkNotNull(this.oidLookup, 1330201676);
        this.assertChunkNotNull(this.commitData, 1128546644);
        GraphObjectIndex index = new GraphObjectIndex(this.hashLength, this.oidFanout, this.oidLookup);
        GraphCommitData commitDataChunk = new GraphCommitData(this.hashLength, this.commitData, this.extraList);
        GraphChangedPathFilterData cpfData = new GraphChangedPathFilterData(this.bloomFilterIndex, this.bloomFilterData);
        return new CommitGraphV1(index, commitDataChunk, cpfData);
    }

    private void assertChunkNotNull(Object object, int chunkId) throws CommitGraphFormatException {
        if (object == null) {
            throw new CommitGraphFormatException(MessageFormat.format(JGitText.get().commitGraphChunkNeeded, Integer.toHexString(chunkId)));
        }
    }

    private void assertChunkNotSeenYet(Object object, int chunkId) throws CommitGraphFormatException {
        if (object != null) {
            throw new CommitGraphFormatException(MessageFormat.format(JGitText.get().commitGraphChunkRepeated, Integer.toHexString(chunkId)));
        }
    }
}

