/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.Git;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.InvalidRefNameException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.errors.ConfigInvalidException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.FileRepository;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.RepositoryBuilder;
import com.xenoterracide.gradle.semver.jgit.util.FS;
import com.xenoterracide.gradle.semver.jgit.util.StringUtils;
import com.xenoterracide.gradle.semver.jgit.util.SystemReader;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.Callable;

public class InitCommand
implements Callable<Git> {
    private File directory;
    private File gitDir;
    private boolean bare;
    private FS fs;
    private String initialBranch;
    private boolean relativePaths;

    @Override
    public Git call() throws GitAPIException {
        try {
            RepositoryBuilder builder = new RepositoryBuilder();
            if (this.bare) {
                builder.setBare();
            }
            if (this.fs != null) {
                builder.setFS(this.fs);
            }
            builder.readEnvironment();
            if (this.gitDir != null) {
                builder.setGitDir(this.gitDir);
            } else {
                this.gitDir = builder.getGitDir();
            }
            if (this.directory != null) {
                if (this.bare) {
                    builder.setGitDir(this.directory);
                } else {
                    builder.setWorkTree(this.directory);
                    if (this.gitDir == null) {
                        builder.setGitDir(new File(this.directory, ".git"));
                    }
                }
            } else if (builder.getGitDir() == null) {
                dStr = SystemReader.getInstance().getProperty("user.dir");
                if (dStr == null) {
                    dStr = ".";
                }
                File d = new File(dStr);
                if (!this.bare) {
                    d = new File(d, ".git");
                }
                builder.setGitDir(d);
            } else if (!this.bare) {
                dStr = SystemReader.getInstance().getProperty("user.dir");
                if (dStr == null) {
                    dStr = ".";
                }
                builder.setWorkTree(new File(dStr));
            }
            builder.setInitialBranch(StringUtils.isEmptyOrNull(this.initialBranch) ? SystemReader.getInstance().getUserConfig().getString("init", null, "defaultbranch") : this.initialBranch);
            Object repository = builder.build();
            if (!((Repository)repository).getObjectDatabase().exists()) {
                if (repository instanceof FileRepository) {
                    ((FileRepository)repository).create(this.bare, this.relativePaths);
                } else {
                    ((Repository)repository).create(this.bare);
                }
            }
            return new Git((Repository)repository, true);
        }
        catch (ConfigInvalidException | IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public InitCommand setDirectory(File directory) throws IllegalStateException {
        InitCommand.validateDirs(directory, this.gitDir, this.bare);
        this.directory = directory;
        return this;
    }

    public InitCommand setGitDir(File gitDir) throws IllegalStateException {
        InitCommand.validateDirs(this.directory, gitDir, this.bare);
        this.gitDir = gitDir;
        return this;
    }

    private static void validateDirs(File directory, File gitDir, boolean bare) throws IllegalStateException {
        if (directory != null) {
            if (bare) {
                if (gitDir != null && !gitDir.equals(directory)) {
                    throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedBareRepoDifferentDirs, gitDir, directory));
                }
            } else if (gitDir != null && gitDir.equals(directory)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedNonBareRepoSameDirs, gitDir, directory));
            }
        }
    }

    public InitCommand setBare(boolean bare) {
        InitCommand.validateDirs(this.directory, this.gitDir, bare);
        this.bare = bare;
        return this;
    }

    public InitCommand setFs(FS fs) {
        this.fs = fs;
        return this;
    }

    public InitCommand setInitialBranch(String branch) throws InvalidRefNameException {
        this.initialBranch = branch;
        return this;
    }

    public InitCommand setRelativeDirs(boolean relativePaths) {
        this.relativePaths = relativePaths;
        return this;
    }
}

